% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{raster2vector}
\alias{raster2vector}
\title{Converts raster image matrix into list of polygons.}
\usage{
raster2vector(raster, from = 0, to = 1, step = 0.1, precision = 1L,
  exclave = TRUE)
}
\arguments{
\item{raster}{input matrix of numeric values.}

\item{from}{lower (greater than) margin for recognizable polygon values.}

\item{to}{upper (less than or equal) margin.}

\item{step}{values gradient.}

\item{precision}{linearization precision in matrix cells.}

\item{exclave}{polygons may have other inside.}
}
\value{
list of integer matrixes that represent polygon coordinates in two columns.
}
\description{
Takes a raster matrix and vectorize it by polygons. Typically the nature of artefact images is linear
and can be vectorized in much more efficient way than draw a series of 90 degrees lines.
}
\examples{
library(datasets)
raster2vector(volcano, 100, 200, 60, 1, FALSE)
raster2vector(volcano, 120, 200, 20)
}
