% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMM.R
\name{gridFastMarch}
\alias{gridFastMarch}
\title{Runs the grid version of the Modified Fast Marching Method}
\usage{
gridFastMarch(domain, seeds, spatial.res = 1)
}
\arguments{
\item{domain}{Grid (matrix) of chosen dimension with diffusivity values
for every grid cell. Values above 1 will boost diffusivity, below 1 will
inhibit it. Values of 0 should mark cells that block diffusion.}

\item{seeds}{A (4 x n) array containing the x-coordinate, y-coordinate,
incept time and rate-of-spread for each of the n seeds.}

\item{spatial.res}{(Optional) Spatial resolution of the grid, necessary only
to correct the rate-of-spread unit. See example below. Defaults to 1.}
}
\description{
This function runs the Modified Fast Marching Method of Silva and Steele
(2012,2014) on a gridded domain.
}
\examples{
# Single process
grid <- matrix(1,10,10)
seed <- c(5,5,0,1)
fm <- gridFastMarch(grid, seed)
image(fm$arrival.time)

# Two processes with same incept time
seeds <- cbind(c(7,7,0,1),c(2,2,0,1))
fm2 <- gridFastMarch(grid, seeds)
par(mfrow=c(1,3))
image(fm2$process, main='process')
image(fm2$arrival.time, main='arrival time')
image(fm2$cost.distance, main='distance')

# Same as before but changing spatial.res parameter
fm3 <- gridFastMarch(grid, seeds, spatial.res=10)

# Same as before but with a barrier in middle
grid[5,2:9] <- 0
fm4 <- gridFastMarch(grid, seeds, spatial.res=10)
par(mfrow=c(1,3))
image(fm4$process, main='process')
image(fm4$arrival.time, main='arrival time')
image(fm4$cost.distance, main='distance')

# Same as before but with different incept times and speeds
seeds <- cbind(c(7,7,0,1),c(2,2,1,0.5))
fm5 <- gridFastMarch(grid, seeds, spatial.res=10)
par(mfrow=c(1,3))
image(fm5$process, main='process')
image(fm5$arrival.time, main='arrival time')
image(fm5$cost.distance, main='distance')
}
\references{
Sethian, J.A. (1996), A fast marching level set method for
monotonically advancing fronts, \emph{Proc. Natl. Acad. Sci.} 93 (4),
1591-1595.

Silva, F. and Steele, J. (2012), Modeling Boundaries Between
Converging Fronts in Prehistory, \emph{Advances in Complex Systems},
 15(1-2), 1150005, <doi:10.1142/S0219525911003293>

Silva, F. and Steele, J. (2014), New methods for reconstructing
geographical effects on dispersal rates and routes from large-scale
radiocarbon databases, \emph{Journal of Archaeological Science} 52,
609-620, <doi:10.1016/j.jas.2014.04.021>
}
