% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.roc.R
\name{conf.roc}
\alias{conf.roc}
\title{Generates confidence intervals for the TPR for a range of FPRs}
\usage{
conf.roc(roc, conf.level = 0.95, steps = 100)
}
\arguments{
\item{roc}{Object of class \code{fbroc.roc}.}

\item{conf.level}{Confidence level to be used for the confidence intervals.}

\item{steps}{Number of discrete steps for the FPR at which the TPR is
calculated. TPR confidence intervals are given for all FPRs in
\code{seq(0, 1, by = (1 / steps))}.}
}
\value{
A data.frame containing the FPR steps and the lower and upper bounds
of the confidence interval for the TPR.
}
\description{
Calculates confidence intervals for the TPR at different FPR values.
This function is also used to plot the confidence regions in the
function \code{\link{plot.fbroc.roc}}.
}
\seealso{
\code{\link{boot.roc}}
}

