% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateScreePlot.R
\name{CreateScreePlot}
\alias{CreateScreePlot}
\title{Create the scree plot for the fitted eigenvalues}
\usage{
CreateScreePlot(fpcaObj, ...)
}
\arguments{
\item{fpcaObj}{A object of class FPCA returned by the function FPCA().}

\item{...}{Additional arguments for the 'plot' function.}
}
\description{
This function will open a new device if not instructed otherwise.
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
CreateScreePlot(res)
}
