% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeGPFunctionalData.R
\name{MakeGPFunctionalData}
\alias{MakeGPFunctionalData}
\title{Create a Dense Functional Data sample for a Gaussian process}
\usage{
MakeGPFunctionalData(n, M = 100, mu = rep(0, M), K = 2,
  lambda = rep(1, K), sigma = 0, basisType = "cos")
}
\arguments{
\item{n}{number of samples to generate}

\item{M}{number of equidistant readings per sample (default: 100)}

\item{mu}{vector of size M specifying the mean (default: rep(0,M))}

\item{K}{scalar specifying the number of basis to be used (default: 2)}

\item{lambda}{vector of size K specifying the variance of each components (default: rep(1,K))}

\item{sigma}{The standard deviation of the Gaussian noise added to each observation points.}

\item{basisType}{string specifying the basis type used; possible options are: 'sin', 'cos' and 'fourier' (default: 'cos') (See code of 'CreateBasis' for implementation details.)}
}
\value{
Y: X(t_{j}), Yn: noisy observations
}
\description{
For a Gaussian process, create a dense functional data sample of size n over a [0,1] support.
}
