% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertFPCA.R
\name{vertFPCA}
\alias{vertFPCA}
\title{Vertical Functional Principal Component Analysis}
\usage{
vertFPCA(warp_data, no, showplot = TRUE)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{no}{number of principal components to extract}

\item{showplot}{show plots of principal directions (default = T)}
}
\value{
Returns a vfpca object containing \item{q_pca}{srvf principal directions}
\item{f_pca}{f principal directions}
\item{latent}{latent values}
\item{coef}{coefficients}
\item{U}{eigenvectors}
}
\description{
This function calculates vertical functional principal component analysis
on aligned data
}
\examples{
data("simu_warp")
vfpca = vertFPCA(simu_warp,no = 3)
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
