% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksamp_perm.R
\name{ksample.perm}
\alias{ksample.perm}
\title{Multiple-sample permutation test for the equality of covariance operators of functional data}
\usage{
ksample.perm(dat, grp, iter = 1000, perm = "sync", dist = "sq",
  adj = TRUE, comb = "tipp", part = FALSE, cent = FALSE, load = FALSE)
}
\arguments{
\item{dat}{n X p data matrix of n samples of p long vectors.}

\item{grp}{n long vector of group labels.}

\item{iter}{Number of permutations. Defaults to 1000.}

\item{perm}{Type of permutation, can be 'sync' (if all the data samples are of the same size) or 'pool'. Defaults to 'sync'}

\item{dist}{Distance between covariance operators. Can be 'sq' (square-root distance), 'tr' (trace distance),'pr' (Procrustes distance), 'hs'(Hilbert-Schmidt distance) or 'op' (operator distance). Defaults to 'sq'.}

\item{adj}{p-value adjustment. Defaults to TRUE.}

\item{comb}{Can be 'tipp' (for Tippett), 'maxT', 'dire' (direct), 'fish' (Fisher) or 'lipt' (Liptak). Defaults to 'tipp'.}

\item{part}{If FALSE, the function computes only the global p-value; otherwise it computes also all the p-values corresponding to the pairwise comparisons. Defaults to FALSE.}

\item{cent}{If FALSE, the mean functions of the groups are supposed to be different, therefore data are centred before performing the test. Defaults to FALSE.}

\item{load}{Boolean flag, which if TRUE, prints a loading bar.}
}
\value{
If \code{part} is set to FALSE, the output is the p-value associated to the global test. If \code{part} is TRUE, the function returns also all the p-values of the pairwise comparisons.
}
\description{
The method performs a test for the equality of the covariance operators of multiple data samples.
It can also perform all of the pairwise comparisons between the groups and compute a p-value for each of them.
This feature is useful when the global null hypothesis is rejected, so one may want to find out which samples have different covariances.
}
\examples{
\dontrun{
## Phoneme data

library(fdcov)
library(fds)

# Create data set 
data(aa); data(ao); data(dcl);data(iy);data(sh)
dat = cbind(aa$y[,1:20],ao$y[,1:20],dcl$y[,1:20],iy$y[,1:20],sh$y[,1:20])
dat = t(dat)
grp = c(rep(1,20),rep(2,20),rep(3,20),rep(4,20),rep(5,20))

# Test the equality of the covariance operators
p = ksample.perm(dat, grp, iter=100, part = TRUE)
p$global # global p-value
p$partial # partial p-values
}
\dontshow{
library(fdcov)
library(fds)

# Create data set 
data(aa); data(ao); data(dcl);data(iy);data(sh)
dat = cbind(aa$y[,1:20],ao$y[,1:20],dcl$y[,1:20],iy$y[,1:20],sh$y[,1:20])
dat = t(dat)
grp = c(rep(1,20),rep(2,20),rep(3,20),rep(4,20),rep(5,20))

# Test the equality of the covariance operators
p = ksample.perm(dat,grp,iter=2)
}
}
\references{
Cabassi, A., Pigoli, D., Secchi, P., Carter, P. A. (2017). 
  Permutation tests for the equality of covariance operators of 
  functional data with applications to evolutionary biology. 
  Electron. J. Statist. 11(2), pp.3815--3840.

  Pigoli, Davide, John A. D. Aston, Ian L. Dryden, and 
  Piercesare Secchi (2014). "Distances and inference for 
  covariance operators." Biometrika: 101(2):409–422.
}
\author{
Alessandra Cabassi \email{alessandra.cabassi@mail.polimi.it}
}
