% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{BAGGING}
\alias{BAGGING}
\title{Classification using Bagging}
\usage{
BAGGING(x, y, learningmethod, nsamples = 100, size = nrow(x), seed = NULL, ...)
}
\arguments{
\item{x}{The dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{y}{The target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{learningmethod}{The boosted method.}

\item{nsamples}{The number of samplings.}

\item{size}{The size of the samples.}

\item{seed}{A specified seed for random number generation.}

\item{...}{Other specific parameters for the leaning method.}
}
\value{
The classification model.
}
\description{
Ensemble learning, through Bagging Algorithm.
}
\examples{
\dontrun{
require (datasets)
data (iris)
BAGGING (iris [, -5], iris [, 5], NB)
}
}
\seealso{
\code{\link{ADABOOST}}, \code{\link{predict.boosting}}
}
