% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{predict.dbs}
\alias{predict.dbs}
\title{Predict function for DBSCAN}
\usage{
\method{predict}{dbs}(object, newdata, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link{dbs-class}}, created by \code{\link{DBSCAN}}).}

\item{newdata}{A new dataset (a \code{data.frame}), with same variables as the learning dataset.}

\item{...}{Other parameters.}
}
\description{
Return the closest DBSCAN cluster for a new dataset.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = DBSCAN (d$train.x, minpts = 5, eps = 0.65)
predict (model, d$test.x)
}
\seealso{
\code{\link{DBSCAN}}
}
