% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{svm}
\alias{svm}
\title{SVM}
\usage{
svm(
  data_train,
  data_test,
  kernel = "linear",
  degree = 3,
  poly = 0,
  includeplot = FALSE
)
}
\arguments{
\item{data_train}{Training set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model is trained.}

\item{data_test}{Test set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model in tested.}

\item{kernel}{Type of kernel to use for SVM model (default:linear)}

\item{degree}{Degree for kernel used (in polynomial or radial case)}

\item{poly}{Binary parameter stating whether the chosen kernel is polynomial of degree greater than 1 (default:0)}

\item{includeplot}{Show performance scatter plot (default:FALSE)}
}
\value{
List containing performance percentages, accessed using training (training accuracy), test (test accuracy), trainsensitivity, testsensitivity, trainspecificity, testspecificity.
}
\description{
SVM
}
\examples{
data_train = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,0,0,1,1)),
      A=c(1,1,1,0,0,0,1,1,1,0),
      B=c(0,1,1,0,1,1,0,1,1,0),
      C=c(0,0,1,0,0,1,0,0,1,0))
data_test = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,1,0)),
      A=c(0,0,0,1,0,0,0,1),
      B=c(1,1,1,0,0,1,1,1),
      C=c(0,0,1,1,0,0,1,1))
svm(data_train,data_test,kernel='radial',degree=3)
svm(data_train,data_test,kernel='sigmoid')
svm(data_train,data_test,kernel='poly',degree=4,poly=1)
}
\keyword{classification}
\keyword{svm}
