% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible_overlap.R
\name{feasible_overlap}
\alias{feasible_overlap}
\title{Find Smallest Feasible Ellipse Overlap}
\usage{
feasible_overlap(ell, ...)
}
\arguments{
\item{ell}{a list of at least two (non degenerate) ellipses; see
\code{\link{wrangle_ellipse}}.}

\item{...}{additional arguments to be passed to internal functions.}
}
\value{
\code{feasible_overlap} returns an object of \code{\link[base]{class}}
"\code{feasible_overlap}". This object is a list with the following entries:
  \item{radii}{the smallest ellipse radii resulting in a non-empty
    intersection.}
  \item{x}{The limiting common point.}
  \item{distance}{The ellipse specific distances.}
  \item{call}{The matched call.}
}
\description{
\code{feasible_overlap} will find the smallest radius such that the ellipses
have a non-empty intersection.
}
\details{
Given a list of ellipses \code{ell} the function \code{feasible_overlap} will
find the smallest radius such that the ellipses from \code{ell} overlap. This
is done by solving the following quadratically constrained problem

\tabular{cclr}{
\ifelse{html}{\out{&nbsp;&nbsp;&nbsp;&nbsp;&nbsp}}{\eqn{\qquad}}\tab
\ifelse{html}{\out{&nbsp min<sub>(x,s)</sub> &nbsp}}{\eqn{\min_{(x,s)}\quad}}
 \tab s \tab \cr
\tab s.t. \tab
\ifelse{html}{\out{(x - c<sub>i</sub>)<sup>T</sup> P<sub>i</sub> (x - c<sub>i</sub>) - r<sub>i</sub> &#8804 s}}{\eqn{(x - c_i)^T P_i (x - c_i) - r_i \leq s}}
\tab \ifelse{html}{\out{&nbsp;&nbsp}}{\eqn{\quad}} for all i = 1, ..., d\cr
}
To solve this convex problem the logarithmic barrier method is used.

Note that it is not necessary to specify ellipse radii in \code{ell}.
}
\examples{
## two dimensional ellipses
e1 <- list("c" = c(1,1), "P" = matrix(c(2,0,0,0.5), ncol = 2))
e2 <- list("c" = c(0,0), "S" = matrix(c(1, 0.2, 0.2, 2), ncol = 2), "r" = 1)
# note: it is not necessary to specify an ellipse radius "r"

feasible_overlap(list(e1, e2))


## regression example
# generate data
n <- 100
E <- rbinom(n, 1, 0.5)
X <- rnorm(n, E * 3, 1)
Y <- rnorm(n, 2 + 1.5 * X, 1)

# create confidence region ellipses
m0 <- lm(Y ~ X, data = data.frame(Y, X), subset = (E == 0))
m1 <- lm(Y ~ X, data = data.frame(Y, X), subset = (E == 1))
ConfRegion0 <- list(c = coefficients(m0), S = vcov(m0))
ConfRegion1 <- list(c = coefficients(m0), S = vcov(m0))

# find smallest radius
res <- feasible_overlap(list(ConfRegion0, ConfRegion1))
# this radius now corresponds to the chisq quantile at which
# the confidence regions intersect non-emptily.
# In other words the (1 - alpha)-confidence intervals intersect for alpha:
alpha <- pchisq(res$radii, 2)

}
\seealso{
\code{\link{wrangle_ellipse}} for detailed on ellipse
parameterization.
}
