% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/league-settings.R
\name{schedule_settings}
\alias{schedule_settings}
\title{League schedule settings}
\usage{
schedule_settings(lid = getOption("lid"), old = FALSE, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\value{
A list or tibble of schedule settings.
}
\description{
The length of a fantasy season and the match periods for each week.
}
\examples{
schedule_settings(252353, old = TRUE)
}
