% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initAFFMeanCD}
\alias{initAFFMeanCD}
\title{Initialisation of AFF change detector}
\usage{
initAFFMeanCD(alpha = 0.01, eta = 0.01, BL = 50)
}
\arguments{
\item{alpha}{The value of the significance level. 
Default value is \code{0.01}, although it is
recommended that the user set this parameter.}

\item{eta}{The value of the step-size in the gradient descent. 
Default is \code{eta=0.01}.}

\item{BL}{The length of the burn-in region. Default value is \code{BL=50}. 
Must be at least greater than or equal to \code{2}. No maximum.
However, there is an exception: \code{BL=0} also works, but in
this case the user needs to specify the \code{streamEstMean} and
\code{streamEstSigma}; see}
}
\description{
This function makes it simple to initalise an FFF object.
}
\examples{
library(Rcpp)
affmeancd1 <- initAFFMeanCD()              # initialises with alpha=0.01, 
                                           # eta=0.01 and BL=50

affmeancd2 <- initAFFMeanCD(alpha=0.005, eta=0.1,  BL=100) 


affmeancd3 <- initAFFMeanCD(alpha=0.005, eta=0.1,  BL=0)     # Example 3
affmeancd3$streamEstMean <- 0
affmeancd3$streamEstSigma <- 1


}
