% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_crack}
\alias{fhir_crack}
\title{Flatten list of FHIR bundles}
\usage{
fhir_crack(
  bundles,
  design,
  sep = NULL,
  remove_empty_columns = NULL,
  brackets = NULL,
  verbose = 2,
  data.table = FALSE,
  add_indices
)
}
\arguments{
\item{bundles}{A FHIR search result as returned by \code{\link{fhir_search}}.}

\item{design}{A named list of data frame descriptions.
Each data frame description will produce one data frame in the list of data frames returned by \code{fhir_crack}, where the data frame has the same name as the data frame description in \code{design}.

Each data frame description is a list of 3 named elements:

1) \code{design$resource}: Mandatory. A string with an XPath expression locating the entries for this data frame in a FHIR bundle page. This is usually the path to a resource tpye
 such as \code{"//Patient"} or \code{"//Observation"}.

2) \code{design$cols}: Optional. Either a string containing an XPath expression referencing a certain level of attributes that should be extracted (
 \code{"./@value"} e.g. would extract all values on the root level) or a named list where the elements are XPath expressions indicating the specific
  position of attributes to extract and the names of the list elements are the column names of the resulting data frame. If \code{design$cols} is \code{NULL},
  all available attributes will be extracted.

3) \code{design$style}: Optional. This can be used instead of the function arguments \code{sep}, \code{brackets} and \code{remove_empty_columns}, but will be
overwritten if the corresponding function arguments are not \code{NULL}.

A named list with the following optional elements:

   a) \code{design$style$sep} : A string to separate pasted multiple entries.

   b) \code{design$style$brackets}: A character vector of length two defining the brackets surrounding indices for multiple entries, e.g. \code{c( "<", ">")}.
      If \code{NULL}, no indices will be added to multiple entries.

   c) \code{design$style$rm_empty_cols}: Logical scalar. Remove empty columns?

For a more detailed explanation and comprehensive examples of \code{design}, please see the package vignette.}

\item{sep}{A string to separate pasted multiple entries. NULL means \code{sep} is looked up in design, if it is \code{NULL} there too, \code{sep} will be set to \code{" "} as the default.}

\item{remove_empty_columns}{Logical scalar. Remove empty columns? \code{NULL} means \code{remove_empty_columns} is looked up in \code{design}, if it is \code{NULL} there too, \code{remove_empty_columns}
will be set to \code{TRUE} as the default.}

\item{brackets}{A character vector of length two defining the brackets surrounding indices for multiple entries, e.g. \code{c( "<", ">")}.
If \code{NULL}, no indices will be added to multiple entries. \code{NULL} means \code{brackets} is looked up in design, if it is \code{NULL} there too, no indices are added.}

\item{verbose}{An Integer Scalar.  If 0, nothing is printed, if 1, only finishing message is printed, if > 1,
extraction progress will be printed. Defaults to 2.}

\item{data.table}{Logical scalar. Should tables be returned in data.table format instead of data.frame?
defaults to FALSE.}

\item{add_indices}{Deprecated. This argument was used to control adding of indices for multiple entries. This is now
done via the brackets argument. If brackets is \code{NULL}, no indices are added, if brackets is not \code{NULL}, indices are added to multiple entries.}
}
\value{
A list of data frames (if \code{data.table = FALSE}) or a list of data.tables
if \code{data.table = TRUE}.
}
\description{
Converts all FHIR bundles (the result of \code{\link{fhir_search}}) to a list of data frames.
}
\examples{
#unserialize example bundle
bundles <- fhir_unserialize(medication_bundles)

#define attributes to extract
design <- list(

 #define specifically which elements to extract
	MedicationStatement = list(

		resource = ".//MedicationStatement",

		cols = list(
				MS.ID              = "id",
				STATUS.TEXT        = "text/status",
				STATUS             = "status",
				MEDICATION.SYSTEM  = "medicationCodeableConcept/coding/system",
				MEDICATION.CODE    = "medicationCodeableConcept/coding/code",
				MEDICATION.DISPLAY = "medicationCodeableConcept/coding/display",
				DOSAGE             = "dosage/text",
				PATIENT            = "subject/reference",
				LAST.UPDATE        = "meta/lastUpdated"
		),

		style = list(
				sep = " ",
				brackets = c("[", "]"),
				rm_empty_cols= FALSE
				)
	),

 #extract all values
	Patients = list(

		resource = ".//Patient"
	)
)

#convert fhir to data frames
list_of_tables <- fhir_crack(bundles, design)

#check results
head(list_of_tables$MedicationStatement)
head(list_of_tables$Patients)


}
