% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{data}
\name{medication_bundles}
\alias{medication_bundles}
\alias{patient_bundles}
\title{Exemplary FHIR bundles}
\format{
An object of class \code{fhir_bundle_list} of length 3.

An object of class \code{fhir_bundle_list} of length 2.
}
\source{
The data sets are generated by the following code:

\strong{medication_bundles} (\emph{Downloaded 10-05-21})\preformatted{search_request  <- fhir_url(url = "https://hapi.fhir.org/baseR4",
							resource = "MedicationStatement",
							parameters = c("code" = "http://snomed.info/ct|429374003",
										   "_include" = "MedicationStatement:subject"))

bundles <- fhir_search(request = search_request, max_bundles = 3)

medication_bundles <- fhir_serialize(bundles = bundles)
}

\strong{patient_bundles} (\emph{Downloaded 10-05-21})\preformatted{bundles <- fhir_search(request="https://hapi.fhir.org/baseR4/Patient",
                       max_bundles=2,
                       verbose = 0)

patient_bundles <- fhir_serialize(bundles = bundles)
}
}
\usage{
medication_bundles

patient_bundles
}
\description{
These data examples can be used to explore some of the functions from the fhircrackr package
when direct access to a FHIR server is not possible.

All example data sets are \linkS4class{fhir_bundle_list}s containing \linkS4class{fhir_bundle_serialized} objects
representing FHIR bundles as returned by \code{\link[=fhir_search]{fhir_search()}}. They have to be unserialized (once per R session),
before you can work with them!
}
\details{
\code{medication_bundles} contains 3 bundles with MedicationStatement resources representing Medications with Snomed CT code
429374003 and the respective Patient resources that are linked to these MedicationStatements.

\code{patient_bundles} contains 2 bundles with Patient resources.
}
\examples{
#unserialize xml objects before doing anything else with them!
fhir_unserialize(bundles = medication_bundles)

#unserialize xml objects before doing anything else with them!
fhir_unserialize(bundles = patient_bundles)
}
\keyword{datasets}
