% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\name{fhir_capability_statement}
\alias{fhir_capability_statement}
\title{Get capability statement}
\usage{
fhir_capability_statement(
  url = "https://hapi.fhir.org/baseR4",
  username = NULL,
  password = NULL,
  token = NULL,
  brackets = NULL,
  sep = " ::: ",
  log_errors = NULL,
  verbose = deprecated()
)
}
\arguments{
\item{url}{The base URL of the FHIR server.}

\item{username}{A character vector of length one containing the username for basic authentication. Defaults to NULL, meaning no authentication.}

\item{password}{A character vector of length one containing the password for basic authentication. Defaults to NULL, meaning no authentication.}

\item{token}{A character vector of length one or object of class \link[httr:Token-class]{httr::Token}, for bearer token authentication (e.g. OAuth2). See \code{\link[=fhir_authenticate]{fhir_authenticate()}}
for how to create this.}

\item{brackets}{A character vector of length two defining the brackets surrounding indices for multiple entries, e.g. \code{c( "[", "]")}. Defaults to \code{NULL}.
If \code{NULL}, no indices will be added to multiple entries.}

\item{sep}{A character vector of length one to separate pasted multiple entries}

\item{log_errors}{Either \code{NULL} or a character vector of length one indicating the name of a file in which to save the http errors.
\code{NULL} means no error logging. When a file name is provided, the errors are saved in the specified file. Defaults to \code{NULL}}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A list of data frames containing the information from the statement
}
\description{
Get the capability statement of a FHIR server.

This function downloads a capability statement and creates three data.frames from it:
\itemize{
\item \code{Meta} contains general information on the server
\item \code{Rest} contains information on the Rest operations the server supports
\item \code{Resources} contains information on the supported resource types
}

When there is more than one piece of information regarding a variable in these data.frames,
they are divided by the string specified in \code{sep}. If \code{brackets} is not NULL, those entries
will also be assigned indices so you can melt them using \code{\link[=fhir_melt]{fhir_melt()}}.
}
\examples{
\dontrun{
#without indices
cap <- fhir_capability_statement(url = "https://server.fire.ly")

#with indices
cap <- fhir_capability_statement(url = "https://server.fire.ly",
                                 brackets = c("[","]"),
                                 sep = " || ")

#melt searchInclude variable
resources <- fhir_melt(cap$Resources,
                       columns = "searchInclude",
                       brackets = c("[", "]"),
                       sep = " || ",
                       all_columns = FALSE)

#remove indices
resources <- fhir_rm_indices(resources, brackets = c("[", "]"))

head(resources)
}
}
