% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{nsubj.plot}
\alias{nsubj.plot}
\title{nsubj.plot}
\usage{
nsubj.plot(
  parent.df,
  category.palette = c("red", "blue"),
  x.label = "Number of Subjects",
  y.label = "Treatment\\nGroup",
  text.size = 4,
  x.col = "XVALUES",
  text.col = "N",
  category.color = "CATEGORY",
  x.limits = c(0.5, 18),
  x.ticks = unique(parent.df$XVALUES),
  x.ticks.labels = unique(parent.df$XVALUES)
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{category.palette}{colors assoicated with categorical variable}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{text.size}{value gets passed to geom_text}

\item{x.col}{parent.df column associated with response vairable (line.plot, nsubj.plot)}

\item{text.col}{used by nsubj.plot}

\item{category.color}{data.frame column assocated with aes color mapping (forest.plot, line.plot, nsubj.plot, table.plot)}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{x.ticks.labels}{passed to scale_x_continuous}
}
\value{
A ggplot object is returned.
}
\description{
A function to create tables to accompany KMs and lineplots
}
\author{
Greg Cicconetti/David Wade
}
