% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hvw_data.R
\name{get_hvw_data}
\alias{get_hvw_data}
\title{Get replication data from Harbridge-Yong, Volden, and Wiseman (2023)}
\usage{
get_hvw_data(chamber, local_path = NULL)
}
\arguments{
\item{chamber}{Which chamber to get data for. Options are:
\itemize{
\item \code{"house"}, \code{"h"}, \code{"hr"}: House data only.
\item \code{"senate"}, \code{"s"}, \code{"sen"}: Senate data only.
}

These options are case-insensitive. Any other argument results in an error.

\strong{Note:} Unlike the Voteview functions, there is no \code{"all"} option.
The House and Senate data do not have the same number of variables,
or the same variable names, so it is not trivial to join the two tables.

You \emph{must} specify either House or Senate data, since there is no "default" option.}

\item{local_path}{(Optional) A file path for reading from a local file.
If no \code{local_path} is specified,  will read data from the Harvard Dataverse website.}
}
\value{
A tibble.
}
\description{
\code{get_hvw_data()} returns replication data from:

Harbridge-Yong, L., Volden, C., & Wiseman, A. E. (2023).
The bipartisan path to effective lawmaking.
\emph{The Journal of Politics}, \emph{85}(3), 1048–1063.
\doi{doi:10.1086/723805}
}
\details{
The replication data is available at the
Harvard Dataverse (\doi{doi:10.7910/DVN/EARLA4}).

The House and Senate data come from the files
\code{HarbridgeYong_Volden_Wiseman_House_Replication.tab} and
\code{HarbridgeYong_Volden_Wiseman_Senate_Replication.tab}, respectively.

The data spans the 93rd through 114th Congresses (1973-2016).

These datasets have been dedicated to the public domain
under \href{https://creativecommons.org/publicdomain/zero/1.0/}{CC0 1.0}.
}
\examples{
\dontshow{if (!is.null(curl::nslookup("dataverse.harvard.edu", error = FALSE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_hvw_data("senate")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive() && !is.null(curl::nslookup("dataverse.harvard.edu", error = FALSE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_hvw_data("house")
\dontshow{\}) # examplesIf}
}
