% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rolling_sd_3}
\alias{rolling_sd_3}
\title{Calculate Standard Deviation Over a Rolling Window of 3}
\usage{
rolling_sd_3(x)
}
\arguments{
\item{x}{an indexed position of a value in a vector for which the rolling standard deviation is needed}
}
\value{
the standard deviation of x, and the two leading values
}
\description{
This function is called within the third filter, and used to calculate a
rolling standard deviation with a window including the 2 leading values.
}
\examples{
# Calculate rolling Standard Deviation
set.seed(1234)
x <- rnorm(n = 100, mean = 10, sd = 1)
rolling_sd_3(x)
}
