% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_compare.R
\name{missing_compare}
\alias{missing_compare}
\title{Compare missing data}
\usage{
missing_compare(.data, dependent, explanatory, na_include = FALSE, ...)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Variable to test missingness against other variables with.}

\item{explanatory}{Variables to have missingness tested against.}

\item{na_include}{Include missing data in explanatory variables as a factor
level.}

\item{...}{Other arguments to \code{\link{summary_factorlist}()}.}
}
\value{
A dataframe comparing missing data in the dependent variable across
  explanatory variables. Continuous data are compared with a Kruskal Wallis
  test. Discrete data are compared with a chi-squared test.
}
\description{
Compare missing data
}
\examples{
library(finalfit)

explanatory = c("age", "age.factor", "extent.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
  ff_glimpse(dependent, explanatory)

colon_s \%>\%
 missing_pattern(dependent, explanatory)

colon_s \%>\%
  missing_compare(dependent, explanatory)
}
