% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.solve_newton}
\alias{.solve_newton}
\title{Newton solver for final size.}
\usage{
.solve_newton(
  contact_matrix,
  demography_vector,
  susceptibility,
  iterations = 10000L,
  tolerance = 1e-06
)
}
\arguments{
\item{contact_matrix}{Social contact matrix. Entry \eqn{mm_{ij}} gives
average number of contacts in group \eqn{i} reported by participants in
group \eqn{j}.}

\item{demography_vector}{Demography vector. Entry \eqn{pp_{i}} gives
proportion of total population in group \eqn{i}
(model will normalise if needed).}

\item{susceptibility}{A matrix giving the susceptibility of individuals in
demographic group \eqn{i} and risk group \eqn{j}.}

\item{iterations}{Number of solver iterations. Defaults to 10,000.}

\item{tolerance}{Solver error tolerance. Solving for final size ends when
the error drops below this tolerance. Defaults to set \code{1e-6}.
Larger tolerance values are likely to lead to inaccurate final size
estimates.}
}
\value{
A two dimensional array of final sizes per age-risk group.
}
\description{
Newton solver for final size.
}
\keyword{internal}
