% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_eff.R
\name{r_eff}
\alias{r_eff}
\title{Calculate \eqn{R_eff} in a heterogeneous population}
\usage{
r_eff(r0, contact_matrix, demography_vector, susceptibility, p_susceptibility)
}
\arguments{
\item{r0}{The basic reproductive number \eqn{R_0} of the infection.}

\item{contact_matrix}{Social contact matrix. Entry \eqn{m_{ij}} gives average
number of contacts in group \eqn{i} reported by participants in group \eqn{j}}

\item{demography_vector}{Demography vector. Entry \eqn{v_{i}} gives
proportion of total population in group \eqn{i} (model will normalise
if needed).}

\item{susceptibility}{A matrix giving the susceptibility of individuals in
demographic group \eqn{i} and risk group \eqn{k}.}

\item{p_susceptibility}{A matrix giving the probability that an individual
in demography group \eqn{i} is in risk (or susceptibility) group \eqn{k}.
Each row represents the overall distribution of individuals in demographic
group \eqn{i} across risk groups, and each row \emph{must sum to 1.0}.}
}
\value{
A single number of the effective reproductive number of the infection
in the population.
}
\description{
\code{r_eff} calculates the effective reproductive number \eqn{R_eff}
in a population with heterogeneous mixing, and with heterogeneous
susceptibility to infection such as due to immunisation.
}
\examples{
# load example POLYMOD data included in the package
data(polymod_uk)
r0 <- 2.0
contact_matrix <- polymod_uk$contact_matrix
demography_vector <- polymod_uk$demography_vector

# define the number of age and susceptibility groups
n_demo_grps <- length(demography_vector)
n_risk_grps <- 3

# In this example, all risk groups from all age groups are fully
# susceptible
susceptibility <- matrix(
  data = 1, nrow = n_demo_grps, ncol = n_risk_grps
)

p_susceptibility <- matrix(
  data = 1, nrow = n_demo_grps, ncol = n_risk_grps
)
# p_susceptibility rows must sum to 1.0
p_susceptibility <- p_susceptibility / rowSums(p_susceptibility)

# calculate R_effective
r_eff(
  r0 = r0,
  contact_matrix = contact_matrix,
  demography_vector = demography_vector,
  susceptibility = susceptibility,
  p_susceptibility = p_susceptibility
)
}
\keyword{R0}
