\name{ruinprob.finite.dsim}
\alias{ruinprob.finite.dsim}

\title{Computation of the probability of ruin within a finite time horizon using a dual process}

\description{
    This function calculates an approximation to the probability of ruin within a finite time
    horizon for a compound Poisson risk process that is perturbed by a Wiener process.  The
    approximation is based on a dual process to the risk process.
}

\usage{ruinprob.finite.dsim(Z)}


\arguments{
  \item{Z}{A time-series object,  e.g. one generated by \link{rriskproc}, containing at least
      two series}
}

\details{
    This function computes an approximation to the probability of ruin within a finite time
    horizon using a dual process.  See the references for more details.
}

\value{
    A function taking one numeric argument, the initial capital.  This function returns the
    approximation for the specified initial reserve and for all values of the time horizon
    that are sampling points of \code{Z}.
}

\references{
Gatto, R. and Baumgartner, B. (to appear, in revision)  \emph{Saddlepoint
    approximations to the probability of ruin in finite time for the compound
    Poisson risk process perturbed by diffusion}. Methodology and Computing in
    Applied Probability \bold{TBA}(TBA), pp. 1--19.
}

%\examples{
%}

%\keyword{ ~kwd1 }
