% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bonito_boot}
\alias{bonito_boot}
\title{Bootstrapped growth estimates for the bonito data set}
\format{
\subsection{\code{bonito_boot}}{

A \code{grotagBoot} object with four columns: \code{Linf}, \code{K},
\code{PhiL}, \code{u}, \code{w} and \code{seed}.
}
}
\usage{
bonito_boot
}
\description{
Bootstrapped growth estimates for the \link[fishmethods]{bonito}
age-growth data calculated using the \link{grotag_boot} as this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data("bonito", package = "fishmethods")

grotag_boot(input.data = bonito,
            alpha = 35, beta = 55,
            design  = list(nu = 1, m = 1,p = 1, sea = 1),
            stvalue = list(sigma = 0.9, nu = 0.4, m = -1,
                           p = 0.2, u = 0.4, w = 0.4),
            upper   = list(sigma = 5, nu = 1, m = 2,
                           p = 0.5, u = 1, w = 1),
            lower   = list(sigma = 0, nu = 0, m = -2,
                           p = 0.0, u = 0, w = 0),
            control = list(maxit = 1e4),
            seed = 1234, nresamp = 100, cc.only = TRUE)
}\if{html}{\out{</div>}}
}
\keyword{datasets}
