% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHGbeta.R
\name{pGHGBB}
\alias{pGHGBB}
\title{Gaussian Hypergeometric Generalized Beta  Binomial Distribution}
\usage{
pGHGBB(x,n,a,b,c)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{n}{single value for no of binomial trials.}

\item{a}{single value for shape parameter alpha value representing a.}

\item{b}{single value for shape parameter beta value representing b.}

\item{c}{single value for shape parameter lambda value representing c.}
}
\value{
The output of \code{pGHGBB} gives cumulative probability function values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Gaussian Hypergeometric Generalized
Beta  Binomial distribution.
}
\details{
Mixing Gaussian Hypergeometric Generalized Beta distribution with Binomial distribution will
create the Gaussian Hypergeometric Generalized Beta Binomial distribution.
The probability function and cumulative probability function can be constructed
and are denoted below.

The cumulative probability function is the summation of probability function values.

\deqn{P_{GHGBB}(x)=\frac{1}{2F1(-n,a;-b-n+1;c)}{n \choose x} \frac{B(x+a,n-x+b)}{B(a,b+n)}(c^x) }
\deqn{a,b,c > 0}
\deqn{x = 0,1,2,...n}
\deqn{n = 1,2,3,...}

The mean, variance and over dispersion are denoted as
\deqn{E_{GHGBB}[x]= nE_{GHGBeta} }
\deqn{Var_{GHGBB}[x]= nE_{GHGBeta}(1-E_{GHGBeta})+ n(n-1)Var_{GHGBeta} }
\deqn{over dispersion= \frac{var_{GHGBeta}}{E_{GHGBeta}(1-E_{GHGBeta})} }

Defined as \eqn{B(a,b)} is the beta function.
Defined as \eqn{2F1(a,b;c;d)} is the Gaussian Hypergeometric function.

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(6)
a <- c(.1,.2,.3,1.5,2.1,3)
plot(0,0,main="GHGBB probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,7),ylim = c(0,0.9))
for (i in 1:6)
{
lines(0:7,dGHGBB(0:7,7,1+a[i],0.3,1+a[i])$pdf,col = col[i],lwd=2.85)
points(0:7,dGHGBB(0:7,7,1+a[i],0.3,1+a[i])$pdf,col = col[i],pch=16)
}

dGHGBB(0:7,7,1.3,0.3,1.3)$pdf      #extracting the pdf values
dGHGBB(0:7,7,1.3,0.3,1.3)$mean     #extracting the mean
dGHGBB(0:7,7,1.3,0.3,1.3)$var      #extracting the variance
dGHGBB(0:7,7,1.3,0.3,1.3)$over.dis.par  #extracting the over dispersion value

#plotting the random variables and cumulative probability values
col <- rainbow(4)
a <- c(1,2,5,10)
plot(0,0,main="Cumulative probability function graph",xlab="Binomial random variable",
ylab="Cumulative probability function values",xlim = c(0,7),ylim = c(0,1))
for (i in 1:4)
{
lines(0:7,pGHGBB(0:7,7,1+a[i],0.3,1+a[i]),col = col[i])
points(0:7,pGHGBB(0:7,7,1+a[i],0.3,1+a[i]),col = col[i])
}

pGHGBB(0:7,7,1.3,0.3,1.3)     #acquiring the cumulative probability values

}
\references{
Rodriguez-Avi, J., Conde-Sanchez, A., Saez-Castillo, A. J., & Olmo-Jimenez, M. J. (2007). A generalization
of the beta-binomial distribution. Journal of the Royal Statistical Society. Series C (Applied Statistics), 56(1), 51-61.

Available at : \url{http://dx.doi.org/10.1111/j.1467-9876.2007.00564.x}

Pearson, J., 2009. Computation of Hypergeometric Functions. Transformation, (September), p.1--123.
}
\seealso{
\code{\link[hypergeo]{hypergeo_powerseries}}
}
