% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPx.R
\name{getPx}
\alias{getPx}
\alias{getPx.default}
\alias{getPx.manyplcfit}
\title{Extract Px from fitted objects}
\usage{
getPx(object, x = 50, coverage = 0.95, rescale_Px = FALSE, ...)

\method{getPx}{default}(object, x = 50, coverage = 0.95,
  rescale_Px = FALSE, ...)

\method{getPx}{manyplcfit}(object, ...)
}
\arguments{
\item{object}{Object returned by any of the fitting functions (e.g. \code{\link{fitplc}})}

\item{x}{The x in Px, that is, if P50 should be returned, x=50. Can be a vector, to return multiple points at once.}

\item{coverage}{The desired coverage of the confidence interval (0.95 is the default).}

\item{rescale_Px}{Logical (default FALSE). If TRUE, rescales calculation of Px for the sigmoidal model, by finding water potential relative to K at zero water potential (which for the sigmoidal model, is not equal to Kmax). If you fitted \code{fitcond} with \code{rescale_Px = TRUE}, make sure to set TRUE here as well to be consistent (it is not assumed from the fitted model, yet).}

\item{\dots}{Further arguments passed to methods (none yet).}
}
\description{
Extract esimates of Px from an object returned by \code{\link{fitplc}}, \code{\link{fitplcs}}, \code{\link{fitcond}} or \code{\link{fitconds}}. This function allows extraction of estimates of P88 or other values when the fit estimated P50 (or other). 

With the Weibull model, it appears to be more robust to set \code{x=50} when fitting the curve, and extracting other points with \code{getPx}.

See examples for use of this function. Note that the confidence interval is based on the bootstrap resampling performed by \code{\link{fitplc}}. If the bootstrap was not performed durinf the fit (i.e. \code{boot=FALSE} in \code{fitplc} or elsewhere), it only returns the fitted values, and not the confidence intervals.
}
\details{
Note that this function does not return a standard error, because the bootstrap confidence interval will be rarely symmetrical. If you like, you can calculate it as the mean of the half CI width (and note it as an 'approximate standard error'). A better approach is to only report the CI and not the SE.

Sometimes the upper CI cannot be calculated and will be reported as \code{NA}. This indicates that the upper confidence bound is outside the range of the data, and can therefore not be reliably reported. It is especially common when \code{x} is large, say for P88.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Calculate Px for a single fitted curve.

\item \code{manyplcfit}: Calculate Px for many fitted curves.
}}

\examples{
# A fit
somefit <- fitplc(stemvul, x=50, model="sigmoid")

# Extract P12, P88
# Note NA for upper CI for P88; this is quite common
# and should be interpreted as falling outside the range of the data.
getPx(somefit, x=c(12,88))

# Extract P88 from multiple fitted curves
fits <- fitplcs(stemvul, "Species", boot=FALSE)
getPx(fits, 88)

}
