% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_maggie.R
\docType{data}
\name{nfl_elo}
\alias{nfl_elo}
\title{The Complete History Of The NFL 2017 NFL Predictions}
\format{Because of R package size restrictions, only a preview of the
first 10 rows of this dataset is included; to obtain the entire dataset
(1920 to present games) see Examples below. The preview is a data frame with 
10 rows representing games and 14 variables:
\describe{
 \item{date}{Date}
 \item{season}{Season year, 1920-2018}
 \item{neutral}{TRUE if the game was played on neutral territory, FALSE if not}
 \item{playoff}{No description provided}
 \item{team1}{The name of one participating team}
 \item{team2}{The name of the other participating team}
 \item{elo1_pre}{Team 1's Elo rating before the game}
 \item{elo2_pre}{Team 2's Elo rating before the game}
 \item{elo_prob1}{Team 1's probability of winning based on Elo rating}
 \item{elo_prob2}{Team 2's probability of winning based on Elo rating}
 \item{elo1_post}{Team 1's Elo rating after the game}
 \item{elo2_post}{Team 2's Elo rating after the game}
 \item{score1}{Points scored by Team 1}
 \item{score2}{Points scored by Team 2}
}}
\source{
See \url{https://projects.fivethirtyeight.com/nfl-api/nfl_elo.csv}
# To obtain the entire dataset, run the following code:
library(readr)
library(dplyr)
library(janitor)

nfl_elo <- 
  "https://projects.fivethirtyeight.com/nfl-api/nfl_elo.csv" %>% 
  read_csv() %>%
  clean_names() %>%
  mutate(
    team1 = as.factor(team1),
    team2 = as.factor(team2),
    neutral = ifelse(neutral == 1, TRUE, FALSE)
  )
}
\usage{
nfl_elo
}
\description{
The raw data behind the story
"The Complete History of the NFL"
\url{https://projects.fivethirtyeight.com/complete-history-of-the-nfl/}
And our "2017 NFL Predictions"
\url{https://projects.fivethirtyeight.com/2017-nfl-predictions/}
}
\keyword{datasets}
