% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compounding-class.R
\name{rates}
\alias{rates}
\alias{rates,Continuous,numeric,numeric-method}
\alias{rates,Discrete,numeric,numeric-method}
\alias{rates,Simple,numeric,numeric-method}
\alias{rates,character,numeric,numeric-method}
\title{Implied rates}
\usage{
rates(x, t, val, ...)
}
\arguments{
\item{x}{a Compounding object or a character with the compounding name.}

\item{t}{a numeric representing the term.}

\item{val}{a numeric representing the compounding factor.}

\item{...}{additional arguments. Currently unused.}
}
\value{
A numeric value that represents a spot rate.
}
\description{
Computes implied rates to compounding factors.
}
\details{
If the \code{x} argument is a \code{character} with a valid compounding name
(\code{simple}, \code{discrete}, \code{continuous}) the function
instanciates a Compounding object and then computes the implied rate
for the given compounding values and terms.
}
\examples{
rates("simple", 2, 1.1)
rates("discrete", 2, 1.1025)
rates("continuous", 2, 1.105170918)

comp <- compounding("discrete")
compound(comp, 0.06, 2) # equals (1 + 0.06) ^ 2 = 1.1236
rates(comp, 1.1236, 2) # equals 0.06
}
