% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{setFixest_coefplot}
\alias{setFixest_coefplot}
\title{Sets the defaults of coefplot}
\usage{
setFixest_coefplot(dict, ci.width = 0.1, ci_level = 0.95,
  pt.pch = 20, cex = par("cex"), pt.cex = cex, col = 1,
  pt.col = col, ci.col = col, lwd = par("lwd"), ci.lwd = lwd,
  ci.lty, grid = TRUE, grid.par = list(lty = 3, col = "gray"),
  zero = TRUE, zero.par = list(col = "black", lwd = 1), join = FALSE,
  join.par = list(lwd = lwd), ref.line, ref.line.par = list(col =
  "black", lty = 2), only.inter = TRUE, reset = TRUE)
}
\arguments{
\item{dict}{(Tex only.) A named character vector. It changes the original variable names to the ones contained in the \code{dict}. E.g. to change the variables named \code{a} and \code{b3} to (resp.) \dQuote{$log(a)$} and to \dQuote{$bonus^3$}, use \code{dict=c(a="$log(a)$",b3="$bonus^3$")}. By default it is equal to \code{getFixest_dict()}, a default dictionary which can be set with \code{\link[fixest]{setFixest_dict}}.}

\item{ci.width}{The width of the extremities of the confidence intervals. Default is \code{0.1}.}

\item{ci_level}{Scalar between 0 and 1: the level of the CI. By default it is equal to 0.95.}

\item{pt.pch}{The patch of the coefficient estimates. Default is 20 (circle).}

\item{cex}{Numeric, default is \code{par("cex")}. Expansion factor for the points}

\item{pt.cex}{The size of the coefficient estimates. Default is the other argument \code{cex}.}

\item{col}{The color of the points and the confidence intervals. Default is 1 ("black"). Note that you can set the colors separately for each of them with \code{pt.col} and \code{ci.col}.}

\item{pt.col}{The color of the coefficient estimate. Default is equal to the other argument \code{col}.}

\item{ci.col}{The color of the confidence intervals. Default is equal to the other argument \code{col}.}

\item{lwd}{General liwe with. Default is par("lwd").}

\item{ci.lwd}{The line width of the confidence intervals. Default is equal to the other argument \code{lwd}.}

\item{ci.lty}{The line type of the confidence intervals. Default is 1.}

\item{grid}{Logical, default is \code{TRUE}. Whether a grid should be displayed. You can set the display of the grid with the argument \code{grid.par}.}

\item{grid.par}{List. Parameters of the grid. The default values are: \code{lty = 3} and \code{col = "gray"}. You can add any graphical parameter that will be passed to \code{\link[graphics]{abline}}. You also have two additional arguments: use \code{horiz = FALSE} to disable the horizontal lines, and use \code{vert = FALSE} to disable the vertical lines. Eg: \code{grid.par = list(vert = FALSE, col = "red", lwd = 2)}.}

\item{zero}{Logical, default is \code{TRUE}. Whether the 0-line should be emphasized. You can set the parameters of that line with the argument \code{zero.par}.}

\item{zero.par}{List. Parameters of the zero-line. The default values are \code{col = "black"} and \code{lwd = 1}. You can add any graphical parameter that will be passed to \code{\link[graphics]{abline}}. Example: \code{zero.par = list(col = "darkblue", lwd = 3)}.}

\item{join}{Logical, default depends on the situation. If \code{TRUE}, then the coefficient estimates are joined with a line. By default, it is equal to \code{TRUE} only if: i) interactions are plotted, ii) the x values are numeric and iii) a reference is found.}

\item{join.par}{List. Parameters of the line joining the cofficients. The default values are: \code{col = pt.col} and \code{lwd = lwd}. You can add any graphical parameter that will be passed to \code{\link[graphics]{lines}}. Eg: \code{join.par = list(lty = 2)}.}

\item{ref.line}{Logical, default depends on the situation. It is \code{TRUE} only if: i) interactions are plotted, ii) the x values are numeric and iii) a reference is found. If \code{TRUE}, then a vertical line is drawn at the level of the reference value. You can set the parameters of this line with the argument \code{ref.line.par}.}

\item{ref.line.par}{List. Parameters of the vertical line on the reference. The default values are: \code{col = "black"} and \code{lty = 2}. You can add any graphical parameter that will be passed to \code{\link[graphics]{abline}}. Eg: \code{ref.line.par = list(lty = 1, lwd = 3)}.}

\item{only.inter}{Logical, default is \code{TRUE}. If an interaction of the type of \code{var::fe} (see \code{\link[fixest]{feols}} help for details) is found, then only these interactions are plotted. If \code{FALSE}, then interactions are treated as regular coefficients.}

\item{reset}{Logical, default is \code{TRUE}. If \code{TRUE}, then the arguments that *are not* set during the call are reset to their "factory"-default values. If \code{FALSE}, on the other hand, arguments that have already been modified are not changed.}
}
\value{
Doesn't return anything.
}
\description{
You can set the default values of most arguments of \code{\link[fixest]{coefplot}} with this function.
}
\examples{

# coefplot has many arguments, which makes it highly flexible.
# If you don't like the default style of coefplot. No worries,
# you can set *your* default by using the function
# setFixest_coefplot()

# Estimation
est = feols(Petal.Length ~ Petal.Width + Sepal.Length +
                Sepal.Width | Species, iris)

# Plot with default style
coefplot(est)

# Now we permanently change some arguments
dict = c("Petal.Length"="Length (Petal)", "Petal.Width"="Width (Petal)",
         "Sepal.Length"="Length (Sepal)", "Sepal.Width"="Width (Sepal)")

setFixest_coefplot(ci.col = 2, pt.col = "darkblue", ci.lwd = 3,
                   pt.cex = 2, pt.pch = 15, ci.width = 0, dict = dict)

# Tadaaa!
coefplot(est)

# To reset to the default settings:
setFixest_coefplot()
coefplot(est)

}
\seealso{
\code{\link[fixest]{coefplot}}
}
