% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createInitialDesign.R
\name{createInitialDesign}
\alias{createInitialDesign}
\title{Create Initial Design}
\usage{
createInitialDesign(n.obs, dim, control)
}
\arguments{
\item{n.obs}{[\code{integer(1)}]\cr
Number of observations.}

\item{dim}{[\code{integer(1)}]\cr
Number of dimensions.}

\item{control}{[\code{list}]\cr
  Control argument. For further information refer to the details.}
}
\value{
[\code{\link{matrix}}].\cr
  A matrix, consisting of \code{n.obs} rows of \code{dim}-dimensional
  observations.
}
\description{
Convenient helper function, which creates an initial design - either based
  on random (uniform) sampling or using a latin hypercube design.
}
\details{
Per default, this function will produce \code{n.obs} observations of size
  \code{dim} in the range from 0 to 1. If you want to create a more specific
  initial design, the following control arguments might be helpful:
  \itemize{
    \item{\code{init_design.type}}: Should the initial design be created
    based on random uniform sampling (\code{"random"}) or on a latin hypercube
    sample (\code{"lhs"})? The default is \code{"random"}.
    \item{\code{init_design.lower}}: The lower bounds of the initial design.
    Either a vector of size \code{dim} or a scalar (if all lower bounds are
    identical). The default is \code{0}.
    \item{\code{init_design.upper}}: The upper bounds of the initial design.
    Either a vector of size \code{dim} or a scalar (if all upper bounds are
    identical). The default is \code{1}.
  }
}
\examples{
# (1) create a simple initial design:
X = createInitialDesign(300, 5)
summary(X)

# (2) create a more specific initial design:
ctrl = list(init_design.type = "lhs",
  init_design.lower = c(-5, 2, 0),
  init_design.upper = 10)
X = createInitialDesign(200, 3, control = ctrl)
summary(X)
}

