% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_importance.R
\name{light_importance}
\alias{light_importance}
\alias{light_importance.default}
\alias{light_importance.flashlight}
\alias{light_importance.multiflashlight}
\title{Permutation Importance.}
\usage{
light_importance(x, ...)

\method{light_importance}{default}(x, ...)

\method{light_importance}{flashlight}(x, data = x$data, by = x$by,
  metric = x$metrics[1], v = NULL, n_max = Inf, seed = NULL,
  lower_is_better = TRUE, use_linkinv = FALSE,
  metric_name = "metric", value_name = "value", label_name = "label",
  variable_name = "variable", ...)

\method{light_importance}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{light_performance}.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{metric}{An optional named list of length one with a metric as element. Defaults to the first metric in the flashlight. The metric needs to be a function with at least four arguments: actual, predicted, case weights w and \code{...}.}

\item{v}{Vector of variables to assess importance for. Defaults to all variables in \code{data}.}

\item{n_max}{Maximum number of rows to consider. Use if \code{data} is large.}

\item{seed}{An integer random seed used to select and shuffle rows.}

\item{lower_is_better}{Logical flag indicating if lower values in the metric are better or not. If set to FALSE, the increase in metric is multiplied by -1.}

\item{use_linkinv}{Should retransformation function be applied? Default is FALSE.}

\item{metric_name}{Name of the resulting column containing the name of the metric. Defaults to "metric".}

\item{value_name}{Column name in resulting \code{data} containing the drop in performance. Defaults to "value".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{variable_name}{Column name in resulting \code{data} containing the variable names. Defaults to "variable".}
}
\value{
An object of class \code{light_importance}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{data} A tibble with results. Can be used to build fully customized visualizations. The columns "value_original" and "value_shuffled" provide the performance before and after shuffling.
  \item \code{by} Same as input \code{by}.
  \item \code{metric_name} Column name representing the name of the metric. For information only.
  \item \code{value_name} Same as input \code{value_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{variable_name} Same as input \code{variable_name}.
}
}
\description{
Calculates performance per variable with respect to a performance measure before and after permuting its values. The difference is a measure of importance, see Fisher et al. 2018 [1].
}
\details{
The minimum required elements in the (multi-) flashlight are "y", "predict_function", "model", "data" and "metrics". The latter two can also directly be passed to \code{light_importance}. Note that by default, no retransformation function is applied.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Variable importance for a flashlight.

\item \code{multiflashlight}: Variable importance for a multiflashlight.
}}

\examples{
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
fit_full <- lm(Sepal.Length ~ ., data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part), by = "Species")
light_importance(mod_full)
light_importance(mods)

ir <- iris
ir$log_sl <- log(ir$Sepal.Length)
fit_lm <- lm(log_sl ~ Petal.Length, data = ir)
fit_glm <- glm(Sepal.Length ~ Petal.Length, data = ir, family = Gamma(link = log))
fl_lm <- flashlight(model = fit_lm, label = "lm", y = "log_sl", linkinv = exp)
fl_glm <- flashlight(model = fit_glm, label = "glm", y = "Sepal.Length",
  predict_function = function(m, X) predict(m, X, type = "response"))
fls <- multiflashlight(list(fl_lm, fl_glm), data = ir)
light_importance(fls, v = "Petal.Length", seed = 45)
light_importance(fls, v = "Petal.Length", seed = 45, use_linkinv = TRUE)
}
\references{
[1] Fisher A., Rudin C., Dominici F. (2018). All Models are Wrong but many are Useful: Variable Importance for Black-Box, Proprietary, or Misspecified Prediction Models, using Model Class Reliance. ArXiv. <https://arxiv.org/abs/1801.01489>.
}
\seealso{
\code{\link{most_important}}, \code{\link{plot.light_importance}}.
}
