% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_effects.R
\name{plot.light_effects}
\alias{plot.light_effects}
\title{Visualize Different Types of Profiles Together}
\usage{
\method{plot}{light_effects}(x, use = c("response", "predicted", "pd"),
  zero_counts = TRUE, size_factor = 1, facet_scales = "free_x",
  facet_nrow = 1L, rotate_x = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{light_effects}.}

\item{use}{A vector with elements in "response", "predicted" and "pd" (partial dependence) with elements to show. Defaults to all.}

\item{zero_counts}{Logical flag if 0 count levels should be shown on the x axis.}

\item{size_factor}{Factor used to enlarge default \code{size} in \code{geom_point} and \code{geom_line}.}

\item{facet_scales}{Scales argument passed to \code{facet_wrap}.}

\item{facet_nrow}{Number of rows in \code{facet_wrap}. Must be 1 if \code{plot_counts} should be used.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{...}{Further arguments passed to geoms.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Visualizes response-, prediction-, and partial dependence profiles of a (multi-)flashlight with respect to a covariable \code{v}. Different flashlights or a single flashlight with one "by" variable are separated by a facet wrap.
}
\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- glm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris,
  y = "Sepal.Length", w = "Petal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris,
  y = "Sepal.Length", w = "Petal.Length")
mods <- multiflashlight(list(mod_full, mod_part))

plot(light_effects(mod_full, v = "Species"))
x <- light_effects(mod_full, v = "Petal.Width")
plot(x)
plot(x, use = "response")

x <- light_effects(mod_full, v = "Petal.Width", stats = "quartiles")
plot(x)
plot_counts(plot(x, use = "response"), x, alpha = 0.2)

x <- light_effects(mod_full, v = "Petal.Width", by = "Species")
plot(x)
p <- plot(x, zero_counts = FALSE)
plot_counts(p, x, alpha = 0.2)

plot(light_effects(mod_full, v = "Petal.Width", by = "Species",
  stats = "quartiles"))
plot(light_effects(mods, v = "Petal.Width", stats = "quartiles"))
}
\seealso{
\code{\link{light_effects}}, \code{\link{plot_counts}}.
}
