% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_profile.R
\name{light_profile}
\alias{light_profile}
\alias{light_profile.default}
\alias{light_profile.flashlight}
\alias{light_profile.multiflashlight}
\title{Partial Dependence and other Profiles}
\usage{
light_profile(x, ...)

\method{light_profile}{default}(x, ...)

\method{light_profile}{flashlight}(
  x,
  v = NULL,
  data = NULL,
  by = x$by,
  type = c("partial dependence", "ale", "predicted", "response", "residual", "shap"),
  stats = c("mean", "quartiles"),
  breaks = NULL,
  n_bins = 11,
  cut_type = c("equal", "quantile"),
  use_linkinv = TRUE,
  value_name = "value",
  q1_name = "q1",
  q3_name = "q3",
  label_name = "label",
  type_name = "type",
  counts_name = "counts",
  counts = TRUE,
  counts_weighted = FALSE,
  v_labels = TRUE,
  pred = NULL,
  pd_evaluate_at = NULL,
  pd_grid = NULL,
  pd_indices = NULL,
  pd_n_max = 1000,
  pd_seed = NULL,
  pd_center = c("no", "first", "middle", "last", "mean", "0"),
  ale_two_sided = FALSE,
  ...
)

\method{light_profile}{multiflashlight}(
  x,
  v = NULL,
  data = NULL,
  breaks = NULL,
  n_bins = 11,
  cut_type = c("equal", "quantile"),
  pd_evaluate_at = NULL,
  pd_grid = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{cut3} resp. \code{formatC} in forming the cut breaks of the \code{v} variable. Not relevant for partial dependence and ALE profiles.}

\item{v}{The variable to be profiled.}

\item{data}{An optional \code{data.frame}. Not used for \code{type = "shap"}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{type}{Type of the profile: Either "partial dependence", "ale", "predicted", "response", "residual", or "shap".}

\item{stats}{Statistic to calculate: "mean" or "quartiles". For ALE profiles, only "mean" makes sense.}

\item{breaks}{Cut breaks for a numeric \code{v}.}

\item{n_bins}{Maxmium number of unique values to evaluate for numeric \code{v}. Only used if neither \code{grid} nor \code{pd_evaluate_at} is specified.}

\item{cut_type}{For the default "equal", bins of equal width are created for \code{v} by \code{pretty}. Choose "quantile" to create quantile bins.}

\item{use_linkinv}{Should retransformation function be applied? Default is TRUE. Not used for type "shap".}

\item{value_name}{Column name in resulting \code{data} containing the profile value. Defaults to "value".}

\item{q1_name}{Name of the resulting column with first quartile values. Only relevant for \code{stats} "quartiles".}

\item{q3_name}{Name of the resulting column with third quartile values. Only relevant for \code{stats} "quartiles".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{type_name}{Column name in the resulting \code{data} with the plot \code{type}.}

\item{counts_name}{Name of the column containing counts if \code{counts} is TRUE.}

\item{counts}{Should counts be added?}

\item{counts_weighted}{If \code{counts} is TRUE: Should counts be weighted by the case weights? If TRUE, the sum of \code{w} is returned by group.}

\item{v_labels}{If FALSE, return group centers of \code{v} instead of labels. Only relevant for types "response", "predicted" or "residual" and if \code{v} is being binned. In that case useful if e.g. different flashlights use different data sets and bin labels would not match.}

\item{pred}{Optional vector with predictions (after application of inverse link). Can be used to avoid recalculation of predictions over and over if the functions is to be repeatedly called for different \code{v} and predictions are computationally expensive to make. Only relevant for \code{type = "predicted"} and \code{type = "ale"}.}

\item{pd_evaluate_at}{Vector with values of \code{v} used to evaluate the profile. Only relevant for type = "partial dependence" and "ale".}

\item{pd_grid}{A \code{data.frame} with grid values, e.g. generated by \code{expand.grid}. Only used for type = "partial dependence".}

\item{pd_indices}{A vector of row numbers to consider in calculating partial dependence profiles. Only used for type = "partial dependence" and "ale".}

\item{pd_n_max}{Maximum number of ICE profiles to calculate (will be randomly picked from \code{data}). Only used for type = "partial dependence" and "ale".}

\item{pd_seed}{Integer random seed used to select ICE profiles. Only used for type = "partial dependence" and "ale".}

\item{pd_center}{How should ICE curves be centered? Default is "no". Choose "first", "middle", or "last" to 0-center at specific evaluation points. Choose "mean" to center all profiles at the within-group means. Choose "0" to mean-center curves at 0. Only relevant for partial dependence.}

\item{ale_two_sided}{If \code{TRUE}, \code{v} is continuous and \code{breaks} are passed or being calculated, then two-sided derivatives are calculated for ALE instead of left derivatives. More specifically: Usually, local effects at value x are calculated using points between x-e and x. Set \code{ale_two_sided = TRUE} to use points between x-e/2 and x+e/2.}
}
\value{
An object of classes \code{light_profile}, \code{light} (and a list) with the following elements.
\itemize{
\item \code{data} A tibble containing results. Can be used to build fully customized visualizations. Its column names are specified by all other items in this list.
\item \code{by} Names of group by variable.
\item \code{v} The variable(s) evaluated.
\item \code{type} Same as input \code{type}. For information only.
\item \code{stats} Same as input \code{stats}.
\item \code{value_name} Same as input \code{value_name}.
\item \code{q1_name} Same as input \code{q1_name}.
\item \code{q3_name} Same as input \code{q3_name}.
\item \code{label_name} Same as input \code{label_name}.
\item \code{type_name} Same as input \code{type_name}.
\item \code{counts_name} Same as input \code{counts_name}.
}
}
\description{
Calculates different types of profiles across covariable values. By default, partial dependence profiles are calculated (see Friedman). Other options are profiles of ALE (accumulated local effects, see Apley), response, predicted values ("M plots" or "marginal plots", see Apley), residuals, and shap. The results are aggregated either by (weighted) means or by (weighted) quartiles. Note that ALE profiles are calibrated by (weighted) average predictions. In contrast to the suggestions in Apley, we calculate ALE profiles of factors in the same order as the factor levels. They are not being reordered based on similiarity of other variables.
}
\details{
For numeric covariables \code{v} with more than \code{n_bins} disjoint values, its values are binned. Alternatively, \code{breaks} can be provided to specify the binning. For partial dependence profiles (and partly also ALE profiles), this behaviour can be overritten either by providing a vector of evaluation points (\code{pd_evaluate_at}) or an evaluation \code{pd_grid}. By the latter we mean a data frame with column name(s) with a (multi-)variate evaluation grid. For partial dependence, ALE, and prediction profiles, "model", "predict_function", linkinv" and "data" are required. For response profiles its "y", "linkinv" and "data" and for shap profiles it is just "shap". "data" can be passed on the fly.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Profiles for flashlight.

\item \code{multiflashlight}: Profiles for multiflashlight.
}}

\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
light_profile(mod_full, v = "Species")
light_profile(mod_full, v = "Species", type = "response")
light_profile(mod_full, v = "Species", stats = "quartiles")
light_profile(mod_full, v = "Petal.Width", type = "residual")
light_profile(mod_full, v = "Petal.Width", pd_evaluate_at = 2:4)
}
\references{
Friedman J. H. (2001). Greedy function approximation: A gradient boosting machine. The Annals of Statistics, 29:1189–1232.

Apley D. W. (2016). Visualizing the effects of predictor variables in black box supervised learning models.
}
\seealso{
\code{\link{light_effects}}, \code{\link{plot.light_profile}}.
}
