% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flattabler.R
\docType{package}
\name{flattabler}
\alias{flattabler}
\title{Obtaining a Flat Table from Pivot Tables}
\description{
Transformations that allow obtaining a flat table from reports in text format
that contain data in the form of pivot tables. They can be defined for a
single report and applied to a set of reports.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

flattabler package provides four categories of functions: Pivot table
import, pivot table definition, pivot table transformation, and flat table
generation.
}
\section{Pivot table import}{

Functions to import pivot tables from a text file or set of files, or to
generate it from a data frame.
\itemize{
\item \code{\link[=read_text_file]{read_text_file()}}
\item \code{\link[=read_text_folder]{read_text_folder()}}
\item \code{\link[=pivot_table]{pivot_table()}}
}
}

\section{Pivot table definition}{
 Functions to view the object, to split a
table into several, to define its characteristics, and to remove the rows
and columns that are not part of the pivot table.
\itemize{
\item \code{\link[=view_table_attr]{view_table_attr()}}
\item \code{\link[=divide]{divide()}}
\item \code{\link[=get_page]{get_page()}}
\item \code{\link[=set_page]{set_page()}}
\item \code{\link[=define_labels]{define_labels()}}
\item \code{\link[=remove_empty]{remove_empty()}}
\item \code{\link[=remove_rows]{remove_rows()}}
\item \code{\link[=remove_cols]{remove_cols()}}
\item \code{\link[=remove_top]{remove_top()}}
\item \code{\link[=remove_bottom]{remove_bottom()}}
\item \code{\link[=remove_left]{remove_left()}}
\item \code{\link[=remove_right]{remove_right()}}
}
}

\section{Pivot table transformation}{

Functions to transform the rows and columns of labels, or the array of values
of the pivot table.
\itemize{
\item \code{\link[=fill_labels]{fill_labels()}}
\item \code{\link[=remove_agg]{remove_agg()}}
\item \code{\link[=extract_labels]{extract_labels()}}
\item \code{\link[=get_col_values]{get_col_values()}}
\item \code{\link[=fill_values]{fill_values()}}
\item \code{\link[=remove_k]{remove_k()}}
\item \code{\link[=replace_dec]{replace_dec()}}
}
}

\section{Flat table generation}{

Functions to generate a flat table from a pivot table and to apply a set of
transformations to a list of tables.
\itemize{
\item \code{\link[=unpivot]{unpivot()}}
\item \code{\link[=flatten_table_list]{flatten_table_list()}}
}
}

