% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{flexiblas-threads}
\alias{flexiblas-threads}
\alias{flexiblas_get_num_threads}
\alias{flexiblas_set_num_threads}
\title{Get/Set Number of Threads}
\usage{
flexiblas_get_num_threads()

flexiblas_set_num_threads(n)
}
\arguments{
\item{n}{number of threads.}
}
\value{
\code{flexiblas_get_num_threads} returns the number of threads.

\code{flexiblas_set_num_threads} returns nothing.
}
\description{
Get or set the number of threads for the BLAS backend.
}
\examples{
\donttest{
max_threads <- 4
n <- 2000
runs <- 10

A <- matrix(runif(n*n), nrow=n)
B <- matrix(runif(n*n), nrow=n)

for (i in seq_len(max_threads)) {
  message("Set number of threads to: ", i)
  flexiblas_set_num_threads(i)

  print(system.time({
    for (j in seq_len(runs))
      C <- A \%*\% B
  }))
}
}

}
\seealso{
\link{flexiblas_avail}, \link{flexiblas_version}, \link{flexiblas-backends}
}
