% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{transform_b}
\alias{transform_b}
\alias{inv_transform_b}
\title{Transform FMP Item Parameters}
\usage{
transform_b(bvec, tvec)

inv_transform_b(bstarvec, tvec)
}
\arguments{
\item{bvec}{Vector of item parameters on the \eqn{\theta} metric: (b0,
b1, b2, b3, ...).}

\item{tvec}{Vector of theta transformation polynomial coefficients: (t0, t1,
t2, t3, ...)}

\item{bstarvec}{Vector of item parameters on the \eqn{\theta^{\star}}{\theta*} metric:
(b*0, b*1, b*2, b*3, ...)}
}
\value{
Vector of transformed FMP item parameters.
}
\description{
Given FMP item parameters for a single item and the polynomial coefficients
defining a latent trait transformation, find the transformed FMP
item parameters.
}
\details{
Equivalent item response models can be written
\deqn{P(\theta) = b_0 + b_1\theta + b_2\theta^2 + \cdots +
b_{2k+1}\theta^{2k+1}}{P(\theta) = b0 + b1\theta + b2\theta^2 + ... +
b(2k+1)\theta^{2k+1}}

and

\deqn{P(\theta^\star) = b^\star_0 + b^\star_1\theta^\star +
b^\star_2\theta^{\star2}+\cdots + b^\star_{2k^\star+1}\theta^{2k^\star+1}}{
P(\theta*) = b*0+b*1\theta* + b*2\theta*^2 + ... + b*_{2k*+1}\theta^{2k*+1}}

where

\deqn{\theta = t_0 + t_1\theta^\star + t_2\theta^{\star 2} + \cdots +
t_{2k_\theta+1}\theta^{\star2k_\theta+1}}{\theta = t0 + t1\theta* +
t2\theta*^2 + ... + t_{2k_\theta+1}\theta*^{2k_\theta+1}.}
}
\examples{

## example parameters from Table 7 of Reise & Waller (2003)
## goal: transform IRT model to sum score metric

a <- c(0.57, 0.68, 0.76, 0.72, 0.69, 0.57, 0.53, 0.64,
       0.45, 1.01, 1.05, 0.50, 0.58, 0.58, 0.60, 0.59,
       1.03, 0.52, 0.59, 0.99, 0.95, 0.39, 0.50)
b <- c(0.87, 1.02, 0.87, 0.81, 0.75, -0.22, 0.14, 0.56,
       1.69, 0.37, 0.68, 0.56, 1.70, 1.20, 1.04, 1.69,
       0.76, 1.51, 1.89, 1.77, 0.39, 0.08, 2.02)

## convert from difficulties and discriminations to FMP parameters

b1 <- 1.702 * a
b0 <- - 1.702 * a * b
bmat <- cbind(b0, b1)

## theta transformation vector (k_theta = 3)
##  see vignette for details about how to find tvec

tvec <- c(-3.80789e+00, 2.14164e+00, -6.47773e-01, 1.17182e-01,
          -1.20807e-02, 7.02295e-04, -2.13809e-05, 2.65177e-07)

## transform bmat
bstarmat <- t(apply(bmat, 1, transform_b, tvec = tvec))

## inspect transformed parameters
signif(head(bstarmat), 2)

## plot test response function
##  should be a straight line if transformation worked

curve(rowSums(irf_fmp(x, bmat = bstarmat)), xlim = c(0, 23),
      ylim = c(0, 23), xlab = expression(paste(theta,"*")),
      ylab = "Expected Sum Score")
abline(0, 1, col = 2)

}
