% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonmixture.R
\name{nmixsurv}
\alias{nmixsurv}
\alias{pnmixsurv}
\alias{hnmixsurv}
\alias{Hnmixsurv}
\alias{dnmixsurv}
\alias{qnmixsurv}
\alias{rnmixsurv}
\alias{rmst_nmixsurv}
\alias{mean_nmixsurv}
\title{Non-Mixture Cure Models}
\usage{
pnmixsurv(pfun, q, theta, ...)

hnmixsurv(dfun, x, theta, ...)

Hnmixsurv(pfun, x, theta, ...)

dnmixsurv(dfun, pfun, x, theta, ...)

qnmixsurv(qfun, p, theta, ...)

rnmixsurv(qfun, n, theta, ...)

rmst_nmixsurv(pfun, t, theta, ...)

mean_nmixsurv(pfun, theta, ...)
}
\arguments{
\item{pfun}{The base distribution's cumulative distribution function.}

\item{theta}{The estimated cure fraction.}

\item{...}{Parameters to be passed to the pdf or cdf of the base
distribution.}

\item{dfun}{The base distribution's probability density function.}

\item{x, q, t}{Vector of times.}

\item{qfun}{The base distribution's quantile function.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random numbers to simulate.}
}
\value{
\code{dnmixsurv} gives the density, \code{pnmixsurv} gives the
distribution function, \code{hnmixsurv} gives the hazard and
\code{Hnmixsurv} gives the cumulative hazard.

\code{qnmixsurv} gives the quantile function, which is computed by crude
numerical inversion.

\code{rnmixsurv} generates random survival times by using \code{qnmixsurv}
on a sample of uniform random numbers.  Due to the numerical root-finding
involved in \code{qnmixsurv}, it is slow compared to typical random number
generation functions.

\code{mean_nmixsurv} and \code{rmst_nmixsurv} give the mean and restricted
mean survival times, respectively.
}
\description{
Probability density, distribution, quantile, random generation, hazard
cumulative hazard, mean, and restricted mean functions for generic
non-mixture cure models.  These distribution functions take as arguments
the corresponding functions of the base distribution used.
}
\details{
es dnmixsurv pnmixsurv qnmixsurv rnmixsurv
hnmixsurv Hnmixsurv mean_nmixsurv rmst_nmixsurv
}
\author{
Jordan Amdahl <jrdnmdhl@gmail.com>
}
\keyword{distribution}
