% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{borders}
\alias{borders}
\alias{border_remove}
\alias{border_outer}
\alias{border_inner_h}
\alias{border_inner_v}
\alias{hline}
\alias{hline_top}
\alias{hline_bottom}
\alias{vline}
\alias{vline_left}
\alias{vline_right}
\title{borders management}
\usage{
border_remove(x)

border_outer(x, border = NULL, part = "all")

border_inner_h(x, border = NULL, part = "body")

border_inner_v(x, border = NULL, part = "all")

hline(x, i = NULL, j = NULL, border = NULL, part = "body")

hline_top(x, j = NULL, border = NULL, part = "body")

hline_bottom(x, j = NULL, border = NULL, part = "body")

vline(x, i = NULL, j = NULL, border = NULL, part = "all")

vline_left(x, i = NULL, border = NULL, part = "all")

vline_right(x, i = NULL, border = NULL, part = "all")
}
\arguments{
\item{x}{a flextable object}

\item{border}{border}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}

\item{i}{rows selection}

\item{j}{columns selection}
}
\description{
These functions let control the horizontal or vertical
borders of a flextable. They are sugar functions and should be used
instead of function \code{\link{border}} that requires careful
settings to avoid overlapping borders.
}
\section{border_remove}{

The function is deleting all borders of the flextable object.
}

\section{border_outer}{

The function is applying a border to outer cells of one
or all parts of a flextable.
}

\section{border_inner_h}{

The function is applying horizontal borders to inner content of one
or all parts of a flextable.
}

\section{border_inner_v}{

The function is applying vertical borders to inner content of one
or all parts of a flextable.
}

\section{hline}{

The function is setting horizontal lines along the part
\code{part} of the flextable object. The lines are the
bottom borders of selected cells.
}

\section{hline_top}{

The function is setting the first horizontal line of the part
\code{part} of the flextable object. The line is the
top border of selected cells of the first row.
}

\section{hline_bottom}{

The function is setting the last horizontal line of the part
\code{part} of the flextable object. The line is the
bottom border of selected cells of the last row.
}

\section{vline}{

The function is setting vertical lines along the part
\code{part} of the flextable object. The lines are the
right borders of selected cells.
}

\section{vline_left}{

The function is setting the first vertical line of the part
\code{part} of the flextable object. The line is the
left border of selected cells of the first column.
}

\section{vline_right}{

The function is setting the last vertical line of the part
\code{part} of the flextable object. The line is the
right border of selected cells of the last column.
}

\examples{
# need officer to define border properties
library(officer)
big_border = fp_border(color="red", width = 2)
std_border = fp_border(color="orange", width = 1)

# dataset to be used for examples
dat <- iris[c(1:5, 51:55, 101:105),]


# use of regulartable() to create a table
ft <- regulartable(dat)

# remove all borders
ft <- border_remove(x = ft)

# add outer borders
ft <- border_outer(ft, part="all", border = big_border )
ft

# add inner horizontal borders
ft <- border_inner_h(ft, border = std_border )
ft

# add inner vertical borders
ft <- border_inner_v(ft, border = std_border )
ft

# new example
ft <- regulartable(dat, col_keys = c("Species", "Sepal.Length",
  "Sepal.Width", "Petal.Length", "Petal.Width" ))
ft <- border_remove(x = ft)

# add horizontal borders
ft <- hline(ft, part="all", border = std_border )
ft

# add horizontal border on top
ft <- hline_top(ft, part="all", border = big_border )
ft

# add/replace horizontal border on bottom
ft <- hline_bottom(ft, part="body", border = big_border )
ft

# add vertical borders
ft <- vline(ft, border = std_border )
ft

# add vertical border on the left side of the table
ft <- vline_left(ft, border = big_border )
ft

# add vertical border on the right side of the table
ft <- vline_right(ft, border = big_border )
ft
}
