% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{plot_chunk}
\alias{plot_chunk}
\title{mini plots chunk wrapper}
\usage{
plot_chunk(
  value,
  width = 1,
  height = 0.2,
  type = "box",
  free_scale = FALSE,
  unit = "in",
  ...
)
}
\arguments{
\item{value}{a numeric vector, stored in a list column.}

\item{width, height}{size of the resulting png file in inches}

\item{type}{type of the plot: 'box', 'line', 'points' or 'density'.}

\item{free_scale}{Should scales be free (TRUE or FALSE, the default value).}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{...}{arguments sent to plot functions (see \code{\link[=par]{par()}})}
}
\description{
This function is used to insert mini plots into
flextable with function \code{\link[=compose]{compose()}}.
It should be used inside a call to \code{\link[=as_paragraph]{as_paragraph()}}.

Available plots are 'box', 'line', 'points', 'density'.
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\section{Illustrations}{


\if{html}{\figure{fig_plot_chunk_1.png}{options: width="400"}}
}

\examples{
library(data.table)
library(flextable)

z <- as.data.table(iris)
z <- z[ , list(
  Sepal.Length = mean(Sepal.Length, na.rm  = TRUE),
  z = list(.SD$Sepal.Length)
  ), by = "Species"]

ft <- flextable(z,
  col_keys = c("Species", "Sepal.Length", "box", "density"))
ft <- mk_par(ft, j = "box", value = as_paragraph(
  plot_chunk(value = z, type = "box",
             border = "red", col = "transparent")))
ft <- mk_par(ft, j = "density", value = as_paragraph(
 plot_chunk(value = z, type = "dens", col = "red")))
ft <- set_table_properties(ft, layout = "autofit", width = .6)
ft <- set_header_labels(ft, box = "boxplot", density= "density")
theme_vanilla(ft)
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()}
}
\concept{chunk elements for paragraph}
