% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_export.R
\name{fc_export}
\alias{fc_export}
\title{fc_export}
\usage{
fc_export(
  object,
  filename,
  path = NULL,
  format = NULL,
  width = NA,
  height = NA,
  units = NULL,
  res = 100,
  ...
)
}
\arguments{
\item{object}{fc object that we want to export.}

\item{filename}{File name to create on disk.}

\item{path}{Path of the directory to save plot to: path and filename are combined to create the fully qualified file name. Defaults to the working directory.}

\item{format}{Name of the graphic device. One of \code{"png"}, \code{"jpeg"}, \code{"tiff"}, \code{"bmp"}, \code{"svg"}, or \code{"pdf"}. If \code{NULL} (default), the format is guessed based on the filename extension.}

\item{width, height}{Plot size in units expressed by the \code{units} argument. Default is 600px for bitmap formats and 6 inches for vector formats.}

\item{units}{One of the following units in which the width and height arguments are expressed: \code{"in"}, \code{"cm"}, \code{"mm"} for vector formats and \code{"in"}, \code{"cm"}, \code{"mm"} or \code{"px"} for bitmap formats. If left \code{NULL} (default), the function will automatically use \code{"px"} for bitmap formats and \code{"in"} for vector formats.}

\item{res}{The nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer. Also used for units other than the default, and to convert points to pixels. Default is 100 if exporting in bitmap format. This argument is unused if exporting to a vector format.}

\item{...}{Arguments to be passed to the device function used to save the flowchart. The available parameters will differ depending on the format (e.g., \link{png}).}
}
\value{
Invisibly returns the same object that has been given to the function.
}
\description{
This function allows you to export the drawn flowchart to the most popular graphic formats, including bitmap formats (png, jpeg, tiff, bmp) and vector formats (svg, pdf). For bitmap formats, it uses the \href{https://ragg.r-lib.org/}{ragg} package devices when available for higher performance and higher quality output than standard raster devices provide by \link{grDevices}.
}
\details{
\itemize{
\item \strong{Vector Formats (\code{'svg'}, \code{'pdf'}):} These formats are ideal for graphics that need to be scaled without loss of quality. The default units for width and height are inches. If user specifies \code{units} other than inches (\code{"mm"} or\code{ "cm"}), the function will convert the dimensions to inches using standard conversion formulas.
\item \strong{Bitmap Formats (\code{'png'}, \code{'jpeg'}, \code{'tiff'}, \code{'bmp'}):} For these formats (with the exception of \code{"bmp"}), the function uses the \href{https://ragg.r-lib.org/}{ragg} package devices when available, providing higher performance and higher quality output. The default \code{units} for \code{width} and \code{height} are pixels.
\item \strong{Suggested Dependencies:} For superior performance and quality bitmap outputs, it is recommended to install the \href{https://ragg.r-lib.org/}{ragg} package. For exporting to \code{"pdf"} format with enhanced features, the Cairo graphics library will be used if it is available.
}
}
\examples{
\dontrun{
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_draw() |>
 fc_export("flowchart.png")

#Specifying size and resolution
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_draw() |>
 fc_export("flowchart.png", width = 3000, height = 4000, res = 700)

#Exporting to an SVG file
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_draw() |>
 fc_export("flowchart.svg")

#Exporting to a PDF file
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_draw() |>
 fc_export("flowchart.pdf")
}
}
