% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.r
\name{fetch}
\alias{fetch}
\alias{fetch_conf}
\alias{fetch_pipes}
\title{Two generic functions to search for pipelines and configuration files.}
\usage{
fetch(x, places, urls, verbose = opts_flow$get("verbose"))

fetch_pipes(x, places, last_only = FALSE,
  urls = opts_flow$get("flowr_pipe_urls"), silent = FALSE,
  verbose = opts_flow$get("verbose"), ask = TRUE)

fetch_conf(x = "flowr.conf", places, ...)
}
\arguments{
\item{x}{name of the file to search for (without extension). 
By default \link{fetch_pipes} and \link{fetch_conf} search for files ending with 
\code{.R} and \code{.conf} respectively.}

\item{places}{places (paths) to look for files matching the name. Defaults are already defined in the function.}

\item{urls}{urls to look for, works well for pipelines [not implemented yet]}

\item{verbose}{A numeric value indicating the amount of messages to produce.
 Values are integers varying from 0, 1, 2, 3, .... Please refer to the \link{verbose} page for more details.
\code{opts_flow$get("verbose")}}

\item{last_only}{fetch_pipes():. If multiple pipelines match the pattern, return the last one. [TRUE]}

\item{silent}{fetch_pipes(): logical, be silent even if no such pipeline is available. [FALSE]}

\item{ask}{ask before downloading or copying. [not implemented]}

\item{...}{[not implemented]}
}
\description{
These functions help in searching for specific files in the user's space.

\code{fetch_pipes()}: Fetches pipelines in the following places, in this specific order:
\itemize{
\item \strong{user's folder}: \code{~/flowr/pipelines}
\item \strong{current wd}: \code{./}
}

\strong{NOTE:} If same pipeline is availabe in multiple places; intitutively, one from the later
folder would be selected. As such, giving priority to user's home, and current working 
directories.

<br>
\code{fetch_conf()}: Fetches configuration files in ALL of the following places:
\itemize{
\item \strong{package}: \code{conf} folders in flowr and ngsflows packages.
\item \strong{user's folder}: \code{~/flowr/conf} folder.
\item \strong{current wd}: \code{./}
}

\strong{NOTE:}
This function would greedily return all matching conf files. One would load all of them 
in the order returned by this function. If the same variable is
repeated in multiple files, value from later files would replace those formerly defined.
Thus ( as explained above ), giving priority to options defined in user's home and current working directories.

By default flowr loads, \code{flowr.conf} and \code{ngsflows.conf}. 
See the details sections, for more explanation on this.
}
\details{
For example flowr has a variable \code{flow_run_path} where it puts all the execution logs etc.
The default value is picked up from the internal \strong{flowr.conf} file.
To redefine this value, one could create a new file called \strong{~/flowr/conf/flowr.conf} and 
add a line:

\code{flow_run_path TAB my_awesome_path}, where \code{TAB} is a tab character, since these are tab 
seperated files.

Also, at any time you can run, \link{opts_flow$load}; to load custom options.
}
\examples{

## let us find a default conf file
conf = fetch_conf("flowr.conf");conf
## load this
opts_flow$load(conf)

## this returns a list, which prints pretty
pip = fetch_pipes("sleep_pipe")
pip$name
pip$pipe
pip$def

}
\seealso{
\link{flowopts}
}

