% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ame.R
\name{ame}
\alias{ame}
\title{Computes AMEs for every feature (or a subset of features) of a model.}
\usage{
ame(model, data, target, features = NULL, ep.method = "none")
}
\arguments{
\item{model}{The (trained) model, with the ability to predict on new data. This must be an \code{Learner} (\code{mlr3}) or \code{train} (\code{caret}) object.}

\item{data}{The data used for computing AMEs, must be data.frame or data.table.}

\item{target}{A string specifying the model's target variable.}

\item{features}{A named character vector of the names of the feature variables for which AMEs should be computed, together with the desired step sizes.}

\item{ep.method}{String specifying the method used for extrapolation detection. One of \code{"none"} or \code{"envelope"}. Defaults to \code{"none"}.}
}
\value{
An \code{AverageMarginalEffects} object, with a field \code{results} containing a list of summary statistics, including
\itemize{
\item \code{Feature}: The name of the feature.
\item \code{step.size}: The step.size w.r.t. the specified feature.
\item \code{AME}: The Average Marginal Effect for a step of length step.size w.r.t. the specified feature.
\item \code{SD}: The standard deviation of FMEs for the specified feature and step.size.
\item \code{SD/AME}: The coefficient of variation for the specified feature and step.size.
\item \code{0.25}: The 0.25-quantile of FMEs for the specified feature and step.size.
\item \code{0.75}: The 0.75-quantile of FMEs for the specified feature and step.size.
\item \code{n}: The number of observations included for the computation of the AME. This can vary for the following reasons:
For categorical features, FMEs are only computed for observations where the original category is not the step.size category.
For numerical features, FMEs are only computed for observations that are not extrapolation points (if ep.method is set to \code{"envelope"}).
}
}
\description{
This is a wrapper function for \code{AverageMarginalEffects$new(...)$compute()}.
It computes Average Marginal Effects (AME) based on Forward Marginal Effects (FME) for a model. The AME is a simple mean FME and computed w.r.t. a feature variable and a model.
}
\examples{
# Train a model:

library(mlr3verse)
library(ranger)
data(bikes, package = "fmeffects")
set.seed(123)
row.id = sample(1:nrow(bikes), 100)
task = as_task_regr(x = bikes, id = "bikes", target = "count")
forest = lrn("regr.ranger")$train(task)

# Compute AMEs for all features:
overview = ame(model = forest, data = bikes[row.id, ], target = "count")
summary(overview)

# Compute AMEs for a subset of features with non-default step.sizes:
overview = ame(model = forest,
               data = bikes[row.id, ],
               target = "count",
               features = c(humidity = 0.1, weather = c("clear", "rain")))
summary(overview)

# Extract results:
overview$results
}
\references{
Scholbeck, C. A., Casalicchio, G., Molnar, C., Bischl, B., & Heumann, C. (2022). Marginal Effects for Non-Linear Prediction Functions.
}
