% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitioning.R
\name{came}
\alias{came}
\title{Computes a partitioning for a \code{ForwardMarginalEffect}}
\usage{
came(
  effects,
  number.partitions = NULL,
  max.sd = Inf,
  rp.method = "ctree",
  tree.control = NULL
)
}
\arguments{
\item{effects}{A \code{ForwardMarginalEffect} object with FMEs computed.}

\item{number.partitions}{The exact number of partitions required.
Either \code{number.partitions} or \code{max.sd} can be specified.}

\item{max.sd}{The maximum standard deviation required in each partition.
Among multiple partitionings with this criterion identified, the one with lowest number of partitions is selected.
Either \code{number.partitions} or \code{max.sd} can be specified.}

\item{rp.method}{One of \code{"ctree"} or \code{"rpart"}. The RP algorithm used for growing the decision tree. Defaults to \code{"ctree"}.}

\item{tree.control}{Control parameters for the RP algorithm. One of \code{"ctree.control(...)"} or \code{"rpart.control(...)"}.
#' @return \code{Partitioning} Object with identified feature subspaces.}
}
\description{
This is a wrapper function that creates the correct subclass of \code{Partitioning}.
It computes feature subspaces for semi-global interpretations of FMEs via recursive partitioning (RP).
}
\examples{
# Train a model and compute FMEs:

library(mlr3verse)
library(ranger)
data(bikes, package = "fmeffects")
task = as_task_regr(x = bikes, id = "bikes", target = "count")
forest = lrn("regr.ranger")$train(task)
effects = fme(model = forest, data = bikes, target = "count", feature = "temp",
              step.size = 1, ep.method = "envelope")

# Find a partitioning with exactly 3 subspaces:
subspaces = came(effects, number.partitions = 3)

# Find a partitioning with a maximum standard deviation of 20, use `rpart`:
library(rpart)
subspaces = came(effects, max.sd = 20, rp.method = "rpart")

# Analyze results:
summary(subspaces)
plot(subspaces)

# Extract results:
subspaces$results
subspaces$tree
}
\references{
Scholbeck, C. A., Casalicchio, G., Molnar, C., Bischl, B., & Heumann, C. (2022). Marginal Effects for Non-Linear Prediction Functions.
}
