% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{fm_CRS}
\alias{fm_CRS}
\alias{is.na.fm_CRS}
\alias{fm_CRS.crs}
\alias{fm_CRS.fm_crs}
\alias{fm_CRS.Spatial}
\alias{fm_CRS.fm_CRS}
\alias{fm_CRS.sf}
\alias{fm_CRS.sfc}
\alias{fm_CRS.sfg}
\alias{fm_CRS.fm_mesh_2d}
\alias{fm_CRS.fm_lattice}
\alias{fm_CRS.fm_segm}
\alias{fm_CRS.matrix}
\alias{fm_CRS.CRS}
\alias{fm_CRS.default}
\alias{is.na.inla.CRS}
\alias{fm_CRS.inla.CRS}
\alias{fm_CRS.inla.mesh}
\alias{fm_CRS.inla.mesh.lattice}
\alias{fm_CRS.inla.mesh.segment}
\title{Create a coordinate reference system object}
\usage{
fm_CRS(x, oblique = NULL, ...)

\method{is.na}{fm_CRS}(x)

\method{fm_CRS}{crs}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_crs}(x, oblique = NULL, ...)

\method{fm_CRS}{Spatial}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_CRS}(x, oblique = NULL, ...)

\method{fm_CRS}{sf}(x, oblique = NULL, ...)

\method{fm_CRS}{sfc}(x, oblique = NULL, ...)

\method{fm_CRS}{sfg}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_mesh_2d}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_lattice}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_segm}(x, oblique = NULL, ...)

\method{fm_CRS}{matrix}(x, oblique = NULL, ...)

\method{fm_CRS}{CRS}(x, oblique = NULL, ...)

\method{fm_CRS}{default}(
  x,
  oblique = NULL,
  projargs = NULL,
  doCheckCRSArgs = NULL,
  args = NULL,
  SRS_string = NULL,
  ...
)

\method{is.na}{inla.CRS}(x)

\method{fm_CRS}{inla.CRS}(x, oblique = NULL, ...)

\method{fm_CRS}{inla.mesh}(x, oblique = NULL, ...)

\method{fm_CRS}{inla.mesh.lattice}(x, oblique = NULL, ...)

\method{fm_CRS}{inla.mesh.segment}(x, oblique = NULL, ...)
}
\arguments{
\item{x}{Object to convert to CRS or to extract CRS information from.}

\item{oblique}{Vector of length at most 4 of rotation angles (in degrees)
for an oblique projection, all values defaulting to zero. The values
indicate (longitude, latitude, orientation, orbit), as explained in the
Details section for \code{\link[=fm_crs]{fm_crs()}}.}

\item{\dots}{Additional parameters, passed on to sub-methods.}

\item{projargs}{Either 1) a projection argument string suitable as input to
\code{sp::CRS}, or 2) an existing \code{CRS} object, or 3) a shortcut
reference string to a predefined projection; run
\code{names(fm_wkt_predef())} for valid predefined projections. (projargs is a
compatibility parameter that can be used for the default \code{fm_CRS()} method)}

\item{doCheckCRSArgs}{ignored.}

\item{args}{An optional list of name/value pairs to add to and/or override
the PROJ4 arguments in \code{projargs}.  \code{name=value} is converted to
\code{"+name=value"}, and \code{name=NA} is converted to \code{"+name"}.}

\item{SRS_string}{a WKT2 string defining the coordinate system;
see \code{sp::CRS}. This takes precedence over \code{projargs}.}
}
\value{
Either an \code{sp::CRS} object or an \code{inla.CRS} object,
depending on if the coordinate reference system described by the parameters
can be expressed with a pure \code{sp::CRS} object or not.

An S3 \code{inla.CRS} object is a list, usually (but not necessarily)
containing at least one element: \item{crs }{The basic \code{sp::CRS}
object}
}
\description{
Creates either a CRS object or an inla.CRS object, describing a coordinate
reference system
}
\details{
The first two
elements of the \code{oblique} vector are the (longitude, latitude)
coordinates for the oblique centre point. The third value (orientation) is a
counterclockwise rotation angle for an observer looking at the centre point
from outside the sphere. The fourth value is the quasi-longitude (orbit
angle) for a rotation along the oblique observers equator.

Simple oblique: \code{oblique=c(0, 45)}

Polar: \code{oblique=c(0, 90)}

Quasi-transversal: \code{oblique=c(0, 0, 90)}

Satellite orbit viewpoint: \code{oblique=c(lon0-time*v1, 0, orbitangle, orbit0+time*v2)}, where \code{lon0} is the longitude at which a satellite
orbit crosses the equator at \code{time=0}, when the satellite is at an
angle \code{orbit0} further along in its orbit.  The orbital angle relative
to the equatorial plane is \code{orbitangle}, and \code{v1} and \code{v2}
are the angular velocities of the planet and the satellite, respectively.
Note that "forward" from the satellite's point of view is "to the right" in
the projection.

When \code{oblique[2]} or \code{oblique[3]} are non-zero, the resulting
projection is only correct for perfect spheres.
}
\section{Functions}{
\itemize{
\item \code{is.na(fm_CRS)}: Check if a \code{fm_CRS} has \code{NA} crs information and \code{NA}
obliqueness

\item \code{is.na(inla.CRS)}: Check if a \code{inla.CRS} has \code{NA} crs information and \code{NA}
obliqueness

}}
\examples{
crs1 <- fm_CRS("longlat_globe")
crs2 <- fm_CRS("lambert_globe")
crs3 <- fm_CRS("mollweide_norm")
crs4 <- fm_CRS("hammer_globe")
crs5 <- fm_CRS("sphere")
crs6 <- fm_CRS("globe")
}
\seealso{
\code{\link[=fm_crs]{fm_crs()}}, \code{\link[sp:CRS-class]{sp::CRS()}}, \code{\link{fm_crs_wkt}},
\code{\link[=fm_sp_get_crs]{fm_sp_get_crs()}}, \code{\link[=fm_crs_is_identical]{fm_crs_is_identical()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
