% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{fm_int_mesh_2d}
\alias{fm_int_mesh_2d}
\alias{fm_int_mesh_2d_NULL}
\alias{fm_int_mesh_2d.sf}
\alias{fm_int_mesh_2d.sfc_POINT}
\alias{fm_int_mesh_2d.sfc_MULTIPOINT}
\alias{fm_int_mesh_2d.sfc_LINESTRING}
\alias{fm_int_mesh_2d.sfc_MULTILINESTRING}
\alias{fm_int_mesh_2d.sfc_POLYGON}
\alias{fm_int_mesh_2d.sfc_MULTIPOLYGON}
\alias{fm_int_mesh_2d.sfc_GEOMETRY}
\alias{fm_int_mesh_2d.Spatial}
\title{Subset integration on a mesh}
\usage{
fm_int_mesh_2d(samplers, domain, name = NULL, int.args = NULL, ...)

fm_int_mesh_2d_NULL(samplers, domain, name = NULL, int.args = NULL, ...)

\method{fm_int_mesh_2d}{sf}(samplers, domain, name = NULL, int.args = NULL, ...)

\method{fm_int_mesh_2d}{sfc_POINT}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_MULTIPOINT}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_LINESTRING}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_MULTILINESTRING}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_POLYGON}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_MULTIPOLYGON}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{sfc_GEOMETRY}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  .weight = rep(1, NROW(samplers)),
  ...
)

\method{fm_int_mesh_2d}{Spatial}(
  samplers,
  domain,
  name = NULL,
  int.args = NULL,
  format = NULL,
  ...
)
}
\arguments{
\item{samplers}{For single domain \code{fm_int} methods, an object specifying one
or more subsets of the domain, and optional weighting in a \code{weight}
variable. For \code{fm_int.list}, a list of sampling definitions, where data
frame elements may contain information for multiple domains, in which case
each row represent a separate tensor product integration subspace.}

\item{domain}{Functional space specification; single domain or a named list
of domains}

\item{name}{For single-domain methods, the variable name to use for the
integration points. Default 'x'}

\item{int.args}{List of arguments passed to line and integration methods.
\itemize{
\item \code{method}: "stable" (to aggregate integration weights onto mesh nodes)
or "direct" (to construct a within triangle/segment integration scheme
without aggregating onto mesh nodes)
\item \code{nsub1}, \code{nsub2}: integers controlling the number of internal integration
points before aggregation. Points per triangle: \code{(nsub2+1)^2}.
Points per knot segment: \code{nsub1}
}}

\item{...}{Additional arguments passed on to other methods}

\item{format}{character; determines the output format, as either "sf"
(default when the sampler is \code{NULL}) or "sp". When \code{NULL}, determined by
the sampler type.}
}
\value{
A \code{list}, \code{sf}, or \code{Spatial} object with
point coordinate information and additional columns \code{weight} and \code{.block}
}
\description{
Integration methods for spatial samplers on \code{fm_mesh_2d} meshes.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_int_mesh_2d(sf)}: \code{sf} integration

\item \code{fm_int_mesh_2d(sfc_POINT)}: \code{sfc_POINT} integration

\item \code{fm_int_mesh_2d(sfc_MULTIPOINT)}: \code{sfc_MULTIPOINT} integration

\item \code{fm_int_mesh_2d(sfc_LINESTRING)}: \code{sfc_LINESTRING} integration

\item \code{fm_int_mesh_2d(sfc_MULTILINESTRING)}: \code{sfc_MULTILINESTRING} integration

\item \code{fm_int_mesh_2d(sfc_POLYGON)}: \code{sfc_POLYGON} integration

\item \code{fm_int_mesh_2d(sfc_MULTIPOLYGON)}: \code{sfc_MULTIPOLYGON} integration

\item \code{fm_int_mesh_2d(sfc_GEOMETRY)}: \code{sfc_GEOMERY} integration

\item \code{fm_int_mesh_2d(Spatial)}: \code{Spatial} integration

}}
\section{Functions}{
\itemize{
\item \code{fm_int_mesh_2d_NULL()}: Full domain integration

}}
\examples{
str(fm_int_mesh_2d(samplers = NULL, domain = fmexample$mesh))
}
\keyword{internal}
