% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{autoplot.decomposed.ts}
\alias{autoplot.decomposed.ts}
\alias{autoplot.stl}
\alias{autoplot.StructTS}
\alias{autoplot.seas}
\title{Plot time series decomposition components using ggplot}
\usage{
\method{autoplot}{decomposed.ts}(object, labels = NULL, range.bars = NULL,
  ...)

\method{autoplot}{stl}(object, labels = NULL, range.bars = TRUE, ...)

\method{autoplot}{StructTS}(object, labels = NULL, range.bars = TRUE, ...)

\method{autoplot}{seas}(object, labels = NULL, range.bars = NULL, ...)
}
\arguments{
\item{object}{Object of class \dQuote{\code{seas}}, \dQuote{\code{stl}}, or
\dQuote{\code{decomposed.ts}}.}

\item{labels}{Labels to replace \dQuote{seasonal}, \dQuote{trend}, and
\dQuote{remainder}.}

\item{range.bars}{Logical indicating if each plot should have a bar at its
right side representing relative size. If \code{NULL}, automatic selection
takes place.}

\item{...}{Other plotting parameters to affect the plot.}
}
\value{
Returns an object of class \code{ggplot}.
}
\description{
Produces a ggplot object of seasonally decomposed time series for objects of
class \dQuote{\code{stl}} (created with \code{\link[stats]{stl}}), class
\dQuote{\code{seas}} (created with \code{\link[seasonal]{seas}}), or class
\dQuote{\code{decomposed.ts}} (created with \code{\link[stats]{decompose}}).
}
\examples{

library(ggplot2)
co2 \%>\% decompose \%>\% autoplot
nottem \%>\% stl(s.window='periodic') \%>\% autoplot

\dontrun{
library(seasonal)
seas(USAccDeaths) \%>\% autoplot
}

}
\seealso{
\code{\link[seasonal]{seas}}, \code{\link[stats]{stl}},
\code{\link[stats]{decompose}}, \code{\link[stats]{StructTS}},
\code{\link[stats]{plot.stl}}.
}
\author{
Mitchell O'Hara-Wild
}
