% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_functions.R
\name{add_buffer_variable}
\alias{add_buffer_variable}
\title{Identify trees in the buffer region}
\usage{
add_buffer_variable(growth_df, direction = "in", size, region)
}
\arguments{
\item{growth_df}{\code{sf} data frame}

\item{direction}{"in" for buffers that are contained within \code{region} (default), "out" for buffers that contain \code{region}.}

\item{size}{Distance to determine which neighboring trees to a focal tree are
competitors. The units are assumed to be the same as the \code{geometry} variables in \code{growth_df}.}

\item{region}{An \code{sf} polygon object of region to be buffered}
}
\value{
The same \code{growth_df} data frame but with a new boolean
variable \code{buffer} indicating if a tree is in the study region buffer
area. This uses \code{\link[=compute_buffer_region]{compute_buffer_region()}} to define the boundary
of the buffer region.
}
\description{
Identify trees in the buffer region
}
\examples{
library(tibble)
library(sfheaders)
library(ggplot2)

# Example square region to be buffered
region <- tibble(
  x = c(0, 0, 1, 1),
  y = c(0, 1, 1, 0)
) \%>\%
  sf_polygon()

# Example points
study_points <- tibble(
  x = runif(50),
  y = runif(50)
) \%>\%
  sf_point()

# Size of buffer
size <- 0.05

# Identify whether points are within size of boundary
study_points <- study_points \%>\%
  add_buffer_variable(direction = "in", size = size, region = region)

# Plot study points coded by whether they are within size of boundary
p <- ggplot() +
  geom_sf(data = region, fill = "transparent") +
  geom_sf(data = study_points, aes(col = buffer))
p

# Additionally, show buffer boundary in red
buffer_boundary <- region \%>\%
  compute_buffer_region(direction = "in", size = size)
p +
  geom_sf(data = buffer_boundary, col = "red", fill = "transparent")
}
\seealso{
Other spatial functions: 
\code{\link{compute_buffer_region}()},
\code{\link{focal_vs_comp_distance}()}
}
\concept{spatial functions}
