% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{census_2_ex}
\alias{census_2_ex}
\title{Example input census data for package use}
\format{
A \code{tibble}
\describe{
\item{ID}{Tree identification number. This identifies an individual tree and
can be used to connect trees between the two censuses.}
\item{sp}{Species of the individual}
\item{gx}{x-coordinate meters from reference point}
\item{gy}{y-coordinate meters from reference point}
\item{date}{Date the stem was measured}
\item{codes}{Code for additional information on the stem: M means the main stem
of the individual tree and R means the stem was lost, but the tag was moved to another stem greater than DBH cutoff,
this stands for resprout.}
\item{dbh}{Diameter at breast height of the tree in cm}
}
}
\usage{
census_2_ex
}
\description{
This is an example second census to be analyzed with the package.
}
\examples{
library(dplyr)
library(stringr)

growth_ex <-
  compute_growth(
    census_1 = census_1_ex \%>\%
      mutate(sp = to_any_case(sp) \%>\% factor()),
    census_2 = census_2_ex \%>\%
      filter(!str_detect(codes, "R")) \%>\%
      mutate(sp = to_any_case(sp) \%>\% factor()),
    id = "ID"
  )
}
\seealso{
Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
