% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diameter_class.R
\name{diameter_class}
\alias{diameter_class}
\title{Divide data into diameter classes, and get number of observations}
\usage{
diameter_class(
  df,
  dbh,
  plot = NA,
  plot_area,
  ci = 5,
  dbhmin = 5,
  species = NA,
  volume = NA,
  NI_label = "NI",
  cc_to_column = FALSE,
  G_to_cc = FALSE,
  cctc_ha = TRUE,
  keep_unused_classes = FALSE
)
}
\arguments{
\item{df}{A data frame.}

\item{dbh}{Quoted name of the diameter at breast height variable, in cm.}

\item{plot}{Optional parameter.Quoted name of the plot variable. used to differentiate the plots trees, and calculate the number of sampled plots. Default \code{NA}.}

\item{plot_area}{Optional parameter. Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters. Default \code{NA}.}

\item{ci}{Numeric value for the class interval used to classify the data. Default: \code{5}.}

\item{dbhmin}{Numeric value for minimum diameter value to be considered in the classifications. dbh values smaller than this will be dismissed from the classification. Default: \code{5}.}

\item{species}{Optional parameter. Quoted name of the scientific names variable, or any variable used to differentiate the different species found in data. If supplied, will be used to classify the species in the diameter data. Default \code{NA}.}

\item{volume}{Optional parameter. Quoted name of the volume variable. If supplied, will be used classify the volume variable in the different diameter classes. Also, if \code{cc_to_column} is \code{TRUE}, the center of class columns will be filled with volume values, instead of number of individuals. Default \code{NA}.}

\item{NI_label}{Label used for Species not identified. This parameter works along with species. The level supplied here will not be considered in the classification. Default \code{"NI"}.}

\item{cc_to_column}{If \code{TRUE}, will spread the center class column as multiple columns, one for each class. The value that fills these columns, by default is the number of individuals found in each class, but this can be changed by using other arguments. Default \code{FALSE}.}

\item{G_to_cc}{If \code{TRUE}, and \code{cc_to_column} is also \code{TRUE}, will fill the center of class columns with basal area values, instead of number of individuals. Default \code{FALSE}.}

\item{cctc_ha}{If \code{TRUE}, will calculate values per hectare for number of individuals per class, basal area per class and volume per class (if supplied). These values will also be used to fill the center of class columns, if cc_to_column is \code{TRUE}. Default \code{TRUE}.}

\item{keep_unused_classes}{Some diameter classes may end up empty, depending on the maximum value of diameter and the class interval used. If this is \code{TRUE}, those classes will not be removed from the final data frame. Default \code{FALSE}.}
}
\value{
A data frame containing the supplied data divided into diameter classes.
}
\description{
This function can be used to divide data into diameter classes,
get the number of observations, number of observations per ha,
and check number of species individuals, volume and G in each diameter class.
It's also possible to spread the diameter classes as columns.
}
\examples{
library(forestmangr)
data("exfm20")
exfm20

# n
# Number of individuals per ha per diameter class
diameter_class(df = exfm20, dbh = "dbh", ci = 10, dbhmin = 10, volume = "vol") 

# Number of individuals per ha per diameter class per species
diameter_class(exfm20,"dbh", "transect", 10000, 10, 10, "scientific.name") 

# Number of individuals per ha per diameter class, with each diameter class as a column
diameter_class(exfm20,"dbh", "transect", 10000, 10, 10, "scientific.name", cc_to_column=TRUE) 

# G
# Basal area per ha per diameter class, with each diameter class as a column
diameter_class(exfm20,"dbh", "transect",10000,10,10,"scientific.name",
cc_to_column=TRUE,G_to_cc=FALSE) 


# Volume
# Volume per ha per diameter class
diameter_class(exfm20,"dbh", "transect", 10000, 10, 10, "scientific.name",volume = "vol") 

# Volume per ha per diameter class, with each diameter class as a column
diameter_class(exfm20,"dbh","transect",10000,10,10,"scientific.name","vol",cc_to_column=TRUE) 

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
