% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pcl.R
\name{read_pcl}
\alias{read_pcl}
\title{\code{read_pcl} imports PCL or portable canopy LiDAR files into the workspace and formats them.}
\usage{
read_pcl(f)
}
\arguments{
\item{f}{name of file currently being processed}
}
\description{
This function specificially reads in PCL files that are in .csv format, standard format for that data type.
}
\examples{

# Link to raw PCL data, in .csv form.
uva_pcl <- system.file("extdata", "UVAX_A4_01W.csv", package = "forestr")

# Import PCL data to the workspace
pcl_data <-read_pcl(uva_pcl)


}
\seealso{
\code{\link{process_pcl}}
\code{\link{process_multi_pcl}}
}
\keyword{data}
\keyword{input}
\keyword{pcl}
\keyword{raw}
\keyword{read}
